/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.watson.discovery.v1.model.NluEnrichmentCategories;
import com.ibm.watson.discovery.v1.model.NluEnrichmentConcepts;
import com.ibm.watson.discovery.v1.model.NluEnrichmentEmotion;
import com.ibm.watson.discovery.v1.model.NluEnrichmentEntities;
import com.ibm.watson.discovery.v1.model.NluEnrichmentKeywords;
import com.ibm.watson.discovery.v1.model.NluEnrichmentRelations;
import com.ibm.watson.discovery.v1.model.NluEnrichmentSemanticRoles;
import com.ibm.watson.discovery.v1.model.NluEnrichmentSentiment;

public class NluEnrichmentFeatures
extends GenericModel {
    private NluEnrichmentKeywords keywords;
    private NluEnrichmentEntities entities;
    private NluEnrichmentSentiment sentiment;
    private NluEnrichmentEmotion emotion;
    private NluEnrichmentCategories categories;
    @SerializedName(value="semantic_roles")
    private NluEnrichmentSemanticRoles semanticRoles;
    private NluEnrichmentRelations relations;
    private NluEnrichmentConcepts concepts;

    private NluEnrichmentFeatures(Builder builder) {
        this.keywords = builder.keywords;
        this.entities = builder.entities;
        this.sentiment = builder.sentiment;
        this.emotion = builder.emotion;
        this.categories = builder.categories;
        this.semanticRoles = builder.semanticRoles;
        this.relations = builder.relations;
        this.concepts = builder.concepts;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public NluEnrichmentKeywords keywords() {
        return this.keywords;
    }

    public NluEnrichmentEntities entities() {
        return this.entities;
    }

    public NluEnrichmentSentiment sentiment() {
        return this.sentiment;
    }

    public NluEnrichmentEmotion emotion() {
        return this.emotion;
    }

    public NluEnrichmentCategories categories() {
        return this.categories;
    }

    public NluEnrichmentSemanticRoles semanticRoles() {
        return this.semanticRoles;
    }

    public NluEnrichmentRelations relations() {
        return this.relations;
    }

    public NluEnrichmentConcepts concepts() {
        return this.concepts;
    }

    public static class Builder {
        private NluEnrichmentKeywords keywords;
        private NluEnrichmentEntities entities;
        private NluEnrichmentSentiment sentiment;
        private NluEnrichmentEmotion emotion;
        private NluEnrichmentCategories categories;
        private NluEnrichmentSemanticRoles semanticRoles;
        private NluEnrichmentRelations relations;
        private NluEnrichmentConcepts concepts;

        private Builder(NluEnrichmentFeatures nluEnrichmentFeatures) {
            this.keywords = nluEnrichmentFeatures.keywords;
            this.entities = nluEnrichmentFeatures.entities;
            this.sentiment = nluEnrichmentFeatures.sentiment;
            this.emotion = nluEnrichmentFeatures.emotion;
            this.categories = nluEnrichmentFeatures.categories;
            this.semanticRoles = nluEnrichmentFeatures.semanticRoles;
            this.relations = nluEnrichmentFeatures.relations;
            this.concepts = nluEnrichmentFeatures.concepts;
        }

        public Builder() {
        }

        public NluEnrichmentFeatures build() {
            return new NluEnrichmentFeatures(this);
        }

        public Builder keywords(NluEnrichmentKeywords keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder entities(NluEnrichmentEntities entities) {
            this.entities = entities;
            return this;
        }

        public Builder sentiment(NluEnrichmentSentiment sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        public Builder emotion(NluEnrichmentEmotion emotion) {
            this.emotion = emotion;
            return this;
        }

        public Builder categories(NluEnrichmentCategories categories) {
            this.categories = categories;
            return this;
        }

        public Builder semanticRoles(NluEnrichmentSemanticRoles semanticRoles) {
            this.semanticRoles = semanticRoles;
            return this;
        }

        public Builder relations(NluEnrichmentRelations relations) {
            this.relations = relations;
            return this;
        }

        public Builder concepts(NluEnrichmentConcepts concepts) {
            this.concepts = concepts;
            return this;
        }
    }
}

