/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.QueryEntitiesContext;
import com.ibm.watson.discovery.v1.model.QueryEntitiesEntity;

public class QueryEntitiesOptions
extends GenericModel {
    private String environmentId;
    private String collectionId;
    private String feature;
    private QueryEntitiesEntity entity;
    private QueryEntitiesContext context;
    private Long count;
    private Long evidenceCount;

    private QueryEntitiesOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.feature = builder.feature;
        this.entity = builder.entity;
        this.context = builder.context;
        this.count = builder.count;
        this.evidenceCount = builder.evidenceCount;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String feature() {
        return this.feature;
    }

    public QueryEntitiesEntity entity() {
        return this.entity;
    }

    public QueryEntitiesContext context() {
        return this.context;
    }

    public Long count() {
        return this.count;
    }

    public Long evidenceCount() {
        return this.evidenceCount;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String feature;
        private QueryEntitiesEntity entity;
        private QueryEntitiesContext context;
        private Long count;
        private Long evidenceCount;

        private Builder(QueryEntitiesOptions queryEntitiesOptions) {
            this.environmentId = queryEntitiesOptions.environmentId;
            this.collectionId = queryEntitiesOptions.collectionId;
            this.feature = queryEntitiesOptions.feature;
            this.entity = queryEntitiesOptions.entity;
            this.context = queryEntitiesOptions.context;
            this.count = queryEntitiesOptions.count;
            this.evidenceCount = queryEntitiesOptions.evidenceCount;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
        }

        public QueryEntitiesOptions build() {
            return new QueryEntitiesOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public Builder entity(QueryEntitiesEntity entity) {
            this.entity = entity;
            return this;
        }

        public Builder context(QueryEntitiesContext context) {
            this.context = context;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder evidenceCount(long evidenceCount) {
            this.evidenceCount = evidenceCount;
            return this;
        }
    }
}

