/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class QueryLogOptions
extends GenericModel {
    private String filter;
    private String query;
    private Long count;
    private Long offset;
    private List<String> sort;

    private QueryLogOptions(Builder builder) {
        this.filter = builder.filter;
        this.query = builder.query;
        this.count = builder.count;
        this.offset = builder.offset;
        this.sort = builder.sort;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String filter() {
        return this.filter;
    }

    public String query() {
        return this.query;
    }

    public Long count() {
        return this.count;
    }

    public Long offset() {
        return this.offset;
    }

    public List<String> sort() {
        return this.sort;
    }

    public static class Builder {
        private String filter;
        private String query;
        private Long count;
        private Long offset;
        private List<String> sort;

        private Builder(QueryLogOptions queryLogOptions) {
            this.filter = queryLogOptions.filter;
            this.query = queryLogOptions.query;
            this.count = queryLogOptions.count;
            this.offset = queryLogOptions.offset;
            this.sort = queryLogOptions.sort;
        }

        public Builder() {
        }

        public QueryLogOptions build() {
            return new QueryLogOptions(this);
        }

        public Builder addSort(String sort) {
            Validator.notNull((Object)sort, (String)"sort cannot be null");
            if (this.sort == null) {
                this.sort = new ArrayList<String>();
            }
            this.sort.add(sort);
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder sort(List<String> sort) {
            this.sort = sort;
            return this;
        }
    }
}

