/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class TestConfigurationInEnvironmentOptions
extends GenericModel {
    private String environmentId;
    private String configuration;
    private InputStream file;
    private String filename;
    private String fileContentType;
    private String metadata;
    private String step;
    private String configurationId;

    private TestConfigurationInEnvironmentOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.isTrue((builder.file == null || builder.filename != null ? 1 : 0) != 0, (String)"filename cannot be null if file is not null.");
        this.environmentId = builder.environmentId;
        this.configuration = builder.configuration;
        this.file = builder.file;
        this.filename = builder.filename;
        this.fileContentType = builder.fileContentType;
        this.metadata = builder.metadata;
        this.step = builder.step;
        this.configurationId = builder.configurationId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String configuration() {
        return this.configuration;
    }

    public InputStream file() {
        return this.file;
    }

    public String filename() {
        return this.filename;
    }

    public String fileContentType() {
        return this.fileContentType;
    }

    public String metadata() {
        return this.metadata;
    }

    public String step() {
        return this.step;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public static class Builder {
        private String environmentId;
        private String configuration;
        private InputStream file;
        private String filename;
        private String fileContentType;
        private String metadata;
        private String step;
        private String configurationId;

        private Builder(TestConfigurationInEnvironmentOptions testConfigurationInEnvironmentOptions) {
            this.environmentId = testConfigurationInEnvironmentOptions.environmentId;
            this.configuration = testConfigurationInEnvironmentOptions.configuration;
            this.file = testConfigurationInEnvironmentOptions.file;
            this.filename = testConfigurationInEnvironmentOptions.filename;
            this.fileContentType = testConfigurationInEnvironmentOptions.fileContentType;
            this.metadata = testConfigurationInEnvironmentOptions.metadata;
            this.step = testConfigurationInEnvironmentOptions.step;
            this.configurationId = testConfigurationInEnvironmentOptions.configurationId;
        }

        public Builder() {
        }

        public Builder(String environmentId) {
            this.environmentId = environmentId;
        }

        public TestConfigurationInEnvironmentOptions build() {
            return new TestConfigurationInEnvironmentOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder file(InputStream file) {
            this.file = file;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder fileContentType(String fileContentType) {
            this.fileContentType = fileContentType;
            return this;
        }

        public Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder step(String step) {
            this.step = step;
            return this;
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public Builder file(File file) throws FileNotFoundException {
            this.file = new FileInputStream(file);
            this.filename = file.getName();
            return this;
        }
    }

    public static interface Step {
        public static final String HTML_INPUT = "html_input";
        public static final String HTML_OUTPUT = "html_output";
        public static final String JSON_OUTPUT = "json_output";
        public static final String JSON_NORMALIZATIONS_OUTPUT = "json_normalizations_output";
        public static final String ENRICHMENTS_OUTPUT = "enrichments_output";
        public static final String NORMALIZATIONS_OUTPUT = "normalizations_output";
    }
}

