/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.command;

import com.ibm.websphere.command.CommandException;
import com.ibm.websphere.command.CommandTarget;
import com.ibm.websphere.command.TargetPolicy;
import com.ibm.websphere.command.TargetPolicyDefault;
import com.ibm.websphere.command.TargetableCommand;
import com.ibm.websphere.command.UnsetInputPropertiesException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public abstract class TargetableCommandImpl
implements TargetableCommand {
    private static final TraceComponent _tc = Tr.register(TargetableCommandImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static String LOCAL = "com.ibm.websphere.command.LocalTarget";
    protected static TargetPolicy targetPolicy = new TargetPolicyDefault();
    protected transient CommandTarget commandTarget = null;
    protected String commandTargetName = null;
    protected boolean hasOutputProperties = true;

    @Override
    public void execute() throws CommandException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"execute", (Object[])new Object[0]);
        }
        if (!this.isReadyToCallExecute()) {
            UnsetInputPropertiesException ex = new UnsetInputPropertiesException();
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{ex});
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{"The command is not ready to execute"});
            }
            throw ex;
        }
        try {
            if (targetPolicy == null) {
                IllegalStateException ex = new IllegalStateException("TargetPolicy is not set");
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{ex});
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{"Target policy is null"});
                }
                throw ex;
            }
            CommandTarget commandTarget = targetPolicy.getCommandTarget(this);
            TargetableCommand returnedCommand = commandTarget.executeCommand(this);
            if (this.hasOutputProperties() && this != returnedCommand) {
                if (returnedCommand == null) {
                    CommandException ex = new CommandException("Command returned from CommandTarget was null and this command has output properties.");
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{ex});
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{"returned command is null"});
                    }
                    throw ex;
                }
                this.setOutputProperties(returnedCommand);
            }
        }
        catch (CommandException ex) {
            FFDCFilter.processException((Throwable)((Object)ex), (String)"com.ibm.websphere.command.TargetableCommandImpl.execute", (String)"133", (Object)this);
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{ex});
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{ex});
            }
            throw ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.websphere.command.TargetableCommandImpl.execute", (String)"137", (Object)this);
            if (ex instanceof RemoteException) {
                RemoteException remoteException = (RemoteException)ex;
                if (remoteException.detail != null) {
                    CommandException e = new CommandException(remoteException.detail);
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{e});
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{e});
                    }
                    throw e;
                }
            }
            CommandException exc = new CommandException(ex);
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{exc});
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"execute", (Object[])new Object[]{exc});
            }
            throw exc;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"execute");
        }
    }

    @Override
    public CommandTarget getCommandTarget() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getCommandTarget", (Object[])new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getCommandTarget", (Object)this.commandTarget);
        }
        return this.commandTarget;
    }

    @Override
    public String getCommandTargetName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getCommandTargetName", (Object[])new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getCommandTargetName", (Object)this.commandTargetName);
        }
        return this.commandTargetName;
    }

    public static TargetPolicy getTargetPolicy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getTargetPolicy", (Object[])new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getTargetPolicy", (Object)targetPolicy);
        }
        return targetPolicy;
    }

    @Override
    public final boolean hasOutputProperties() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"hasOutputProperties", (Object[])new Object[0]);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"hasOutputProperties", (Object)new Boolean(this.hasOutputProperties));
        }
        return this.hasOutputProperties;
    }

    @Override
    public abstract boolean isReadyToCallExecute();

    @Override
    public abstract void performExecute() throws Exception;

    @Override
    public abstract void reset();

    @Override
    public void setCommandTarget(CommandTarget commandTarget) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"setCommandTarget", (Object[])new Object[]{commandTarget});
        }
        this.commandTarget = commandTarget;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setCommandTarget");
        }
    }

    @Override
    public void setCommandTargetName(String commandTargetName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"setCommandTargetName", (Object[])new Object[]{commandTargetName});
        }
        this.commandTargetName = commandTargetName;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setCommandTargetName");
        }
    }

    public final void setHasOutputProperties(boolean inProp) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"setHasOutputProperties", (Object[])new Object[]{new Boolean(inProp)});
        }
        this.hasOutputProperties = inProp;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setHasOutputProperties");
        }
    }

    @Override
    public void setOutputProperties(final TargetableCommand fromCommand) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"setOutputProperties", (Object[])new Object[]{fromCommand});
        }
        try {
            final Class<?> theClass = this.getClass();
            final TargetableCommandImpl outerThis = this;
            if (!fromCommand.getClass().equals(theClass)) {
                IllegalStateException ex = new IllegalStateException("fromCommand is not of the same class");
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"setOutputProperties", (Object[])new Object[]{ex});
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"setOutputProperties", (Object[])new Object[]{"fromCommand is not of the same class"});
                }
                throw ex;
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AccessibleObject[] fields = theClass.getDeclaredFields();
                    Field.setAccessible(fields, true);
                    for (int i = 0; i < fields.length; ++i) {
                        int modifiers = ((Field)fields[i]).getModifiers();
                        if (Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) continue;
                        ((Field)fields[i]).set(outerThis, ((Field)fields[i]).get(fromCommand));
                    }
                    Field.setAccessible(fields, false);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.websphere.command.TargetableCommandImpl.setOutputProperties", (String)"371", (Object)this);
            IllegalStateException e = new IllegalStateException("Since not all your variables are public in your command, you need to override the default implementation of TargetableCommand.setOutputProperties().");
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"setOutputProperties", (Object[])new Object[]{e});
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setOutputProperties");
        }
    }

    public static void setTargetPolicy(TargetPolicy targetPolicy) {
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setTargetPolicy", (Object)targetPolicy);
        }
        TargetableCommandImpl.targetPolicy = targetPolicy;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setTargetPolicy");
        }
    }
}

