/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ola;

import jakarta.resource.cci.IndexedRecord;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class IndexedRecordImpl
implements IndexedRecord {
    private static final long serialVersionUID = 1607302106806298841L;
    private static final String RECORD_BYTES_CLASSNAME = "com.ibm.etools.marshall.RecordBytes";
    private ArrayList<byte[]> records = new ArrayList();
    private String recordName;
    private String description;

    public IndexedRecordImpl() {
    }

    private IndexedRecordImpl(IndexedRecordImpl base) {
        this.recordName = base.getRecordName();
        this.description = base.getRecordShortDescription();
        ArrayList<byte[]> list = base.records;
        this.records = (ArrayList)list.clone();
    }

    public String getRecordName() {
        return this.recordName;
    }

    public String getRecordShortDescription() {
        return this.description;
    }

    public void setRecordName(String arg0) {
        this.recordName = arg0;
    }

    public void setRecordShortDescription(String arg0) {
        this.description = arg0;
    }

    private boolean isRecordBytes(Object o) {
        try {
            Class<?> recordClass = o.getClass();
            ClassLoader cl = recordClass.getClassLoader();
            Class<?> recordBytesClass = cl.loadClass(RECORD_BYTES_CLASSNAME);
            return recordBytesClass.isAssignableFrom(recordClass);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean add(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof byte[]) {
            this.records.add((byte[])o);
        } else if (this.isRecordBytes(o)) {
            try {
                Class<?> c = o.getClass();
                Method m = c.getMethod("getBytes", new Class[0]);
                this.records.add((byte[])m.invoke(o, (Object[])null));
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Unable to store RecordBytes into IndexedRecord", t);
            }
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
        return true;
    }

    public void add(int index, Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof byte[]) {
            this.records.add(index, (byte[])o);
        } else if (this.isRecordBytes(o)) {
            try {
                Class<?> c = o.getClass();
                Method m = c.getMethod("getBytes", new Class[0]);
                this.records.add(index, (byte[])m.invoke(o, (Object[])null));
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Unable to store RecordBytes into IndexedRecord", t);
            }
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
    }

    public boolean addAll(Collection c) {
        LinkedList<byte[]> tempList = new LinkedList<byte[]>();
        if (c == null) {
            throw new NullPointerException();
        }
        for (Object o : c) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (o instanceof byte[]) {
                tempList.add((byte[])o);
                continue;
            }
            if (this.isRecordBytes(o)) {
                try {
                    Class<?> cl = o.getClass();
                    Method m = cl.getMethod("getBytes", new Class[0]);
                    tempList.add((byte[])m.invoke(o, (Object[])null));
                    continue;
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException("Unable to store RecordBytes into IndexedRecord", t);
                }
            }
            throw new IllegalArgumentException("Invalid type contained within the collection");
        }
        return this.records.addAll(tempList);
    }

    public boolean addAll(int index, Collection c) {
        LinkedList<byte[]> tempList = new LinkedList<byte[]>();
        if (c == null) {
            throw new NullPointerException();
        }
        for (Object o : c) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (o instanceof byte[]) {
                tempList.add((byte[])o);
                continue;
            }
            if (this.isRecordBytes(o)) {
                try {
                    Class<?> cl = o.getClass();
                    Method m = cl.getMethod("getBytes", new Class[0]);
                    tempList.add((byte[])m.invoke(o, (Object[])null));
                    continue;
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException("Unable to store RecordBytes into IndexedRecord", t);
                }
            }
            throw new IllegalArgumentException("Invalid type contained within the collection");
        }
        return this.records.addAll(index, tempList);
    }

    public void clear() {
        this.records.clear();
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public boolean containsAll(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        boolean found = true;
        Iterator i = c.iterator();
        while (i.hasNext() && found) {
            Object o = i.next();
            found = this.contains(o);
        }
        return found;
    }

    public Object get(int index) {
        return this.records.get(index);
    }

    public int indexOf(Object o) {
        byte[] data = null;
        int index = -1;
        if (o != null) {
            if (o instanceof byte[]) {
                data = (byte[])o;
            } else if (this.isRecordBytes(o)) {
                try {
                    Class<?> c = o.getClass();
                    Method m = c.getMethod("getBytes", new Class[0]);
                    data = (byte[])m.invoke(o, (Object[])null);
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException("Unable to store RecordBytes into IndexedRecord", t);
                }
            }
            if (data != null) {
                ListIterator<byte[]> i = this.records.listIterator();
                while (i.hasNext() && index == -1) {
                    int curIndex = i.nextIndex();
                    byte[] curData = i.next();
                    if (curData.length != data.length || !Arrays.equals(curData, data)) continue;
                    index = curIndex;
                }
            }
        }
        return index;
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public Iterator iterator() {
        return this.records.iterator();
    }

    public int lastIndexOf(Object o) {
        byte[] data = null;
        int index = -1;
        if (o != null) {
            if (o instanceof byte[]) {
                data = (byte[])o;
            } else if (this.isRecordBytes(o)) {
                try {
                    Class<?> c = o.getClass();
                    Method m = c.getMethod("getBytes", new Class[0]);
                    data = (byte[])m.invoke(o, (Object[])null);
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException("Unable to store RecordBytes into IndexedRecord", t);
                }
            }
            if (data != null) {
                for (int i = this.records.size() - 1; i >= 0 && index == -1; --i) {
                    byte[] curData = this.records.get(i);
                    if (curData.length != data.length || !Arrays.equals(curData, data)) continue;
                    index = i;
                }
            }
        }
        return index;
    }

    public ListIterator listIterator() {
        return this.records.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.records.listIterator(index);
    }

    public boolean remove(Object o) {
        boolean removed = false;
        int index = this.indexOf(o);
        if (index != -1) {
            this.records.remove(index);
            removed = true;
        }
        return removed;
    }

    public Object remove(int index) {
        return this.records.remove(index);
    }

    public boolean removeAll(Collection c) {
        boolean removedSomething = false;
        if (c == null) {
            throw new NullPointerException();
        }
        for (Object o : c) {
            if (!this.remove(o)) continue;
            removedSomething = true;
        }
        return removedSomething;
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public Object set(int index, Object o) {
        byte[] data = null;
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof byte[]) {
            data = (byte[])o;
        } else if (this.isRecordBytes(o)) {
            try {
                Class<?> c = o.getClass();
                Method m = c.getMethod("getBytes", new Class[0]);
                data = (byte[])m.invoke(o, (Object[])null);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Unable to store RecordBytes into IndexedRecord", t);
            }
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
        return this.records.set(index, data);
    }

    public int size() {
        return this.records.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.records.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.records.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.records.toArray(a);
    }

    public Object clone() throws CloneNotSupportedException {
        return new IndexedRecordImpl(this);
    }
}

