/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.AccessController;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.glassfish.jersey.internal.inject.ExtractorException;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.NullableMultivaluedHashMap;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.ReaderWriter;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueParamProvider;

@Singleton
final class FormParamValueParamProvider
extends AbstractValueParamProvider {
    private final MultipartFormParamValueProvider multipartProvider;

    public FormParamValueParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep, InjectionManager injectionManager) {
        super(mpep, Parameter.Source.FORM);
        this.multipartProvider = new MultipartFormParamValueProvider(injectionManager);
    }

    @Override
    public Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.isEmpty()) {
            return null;
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new FormParamValueProvider(e, this.multipartProvider, !parameter.isEncoded(), parameter);
    }

    @Singleton
    private static class MultipartFormParamValueProvider
    implements BiFunction<ContainerRequest, Parameter, Object> {
        private static Parameter entityPartParameter = (Parameter)Parameter.create(EntityPart.class, EntityPart.class, false, EntityPart.class, EntityPart.class, AccessController.doPrivileged(ReflectionHelper.getDeclaredFieldsPA(FormParamHolder.class))[0].getAnnotations());
        private final InjectionManager injectionManager;
        private final LazyValue<ValueParamProvider> entityPartProvider;

        private MultipartFormParamValueProvider(InjectionManager injectionManager) {
            this.injectionManager = injectionManager;
            this.entityPartProvider = Values.lazy(() -> {
                Set<ValueParamProvider> providers = Providers.getProviders(injectionManager, ValueParamProvider.class);
                for (ValueParamProvider vfp : providers) {
                    Function<ContainerRequest, ?> paramValueSupplier = vfp.getValueProvider(entityPartParameter);
                    if (paramValueSupplier == null || FormParamValueParamProvider.class.isInstance(vfp)) continue;
                    return vfp;
                }
                return null;
            });
        }

        @Override
        public Object apply(ContainerRequest containerRequest, Parameter parameter) {
            Object entity = null;
            if (this.entityPartProvider.get() != null) {
                Function<ContainerRequest, ?> valueSupplier = ((ValueParamProvider)this.entityPartProvider.get()).getValueProvider(new WrappingFormParamParameter(entityPartParameter, parameter));
                EntityPart entityPart = (EntityPart)valueSupplier.apply(containerRequest);
                try {
                    entity = (parameter.getType() != parameter.getRawType() ? entityPart.getContent(this.genericType(parameter.getRawType(), parameter.getType())) : entityPart.getContent(parameter.getRawType()));
                }
                catch (IOException e) {
                    throw new ProcessingException(e);
                }
            }
            return entity;
        }

        private GenericType genericType(final Type rawType, final Type genericType) {
            return new GenericType(new ParameterizedType(){

                @Override
                public Type[] getActualTypeArguments() {
                    return new Type[]{genericType};
                }

                @Override
                public Type getRawType() {
                    return rawType;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }
            });
        }

        private static class WrappingFormParamParameter
        extends Parameter {
            protected WrappingFormParamParameter(Parameter entityPartDataParam, Parameter realDataParam) {
                super(realDataParam.getAnnotations(), realDataParam.getSourceAnnotation(), realDataParam.getSource(), realDataParam.getSourceName(), entityPartDataParam.getRawType(), entityPartDataParam.getType(), realDataParam.isEncoded(), realDataParam.getDefaultValue());
            }
        }

        private static final class FormParamHolder {
            @FormParam(value="name")
            public static final Void dummy = null;

            private FormParamHolder() {
            }
        }
    }

    private static final class FormParamValueProvider
    implements Function<ContainerRequest, Object> {
        private static final Annotation encodedAnnotation = FormParamValueProvider.getEncodedAnnotation();
        private final MultivaluedParameterExtractor<?> extractor;
        private final MultipartFormParamValueProvider multipartProvider;
        private final boolean decode;
        private final Parameter parameter;

        FormParamValueProvider(MultivaluedParameterExtractor<?> extractor, MultipartFormParamValueProvider multipartProvider, boolean decode, Parameter parameter) {
            this.extractor = extractor;
            this.multipartProvider = multipartProvider;
            this.decode = decode;
            this.parameter = parameter;
        }

        private static Form getCachedForm(ContainerRequest request, boolean decode) {
            return (Form)request.getProperty(decode ? "jersey.config.server.representation.decoded.form" : "jersey.config.server.representation.form");
        }

        private static ContainerRequest ensureValidRequest(ContainerRequest request) throws IllegalStateException {
            if (request.getMethod().equals("GET")) {
                throw new IllegalStateException(LocalizationMessages.FORM_PARAM_METHOD_ERROR());
            }
            if (!MediaTypes.typeEqual(MediaType.APPLICATION_FORM_URLENCODED_TYPE, request.getMediaType())) {
                throw new IllegalStateException(LocalizationMessages.FORM_PARAM_CONTENT_TYPE_ERROR());
            }
            return request;
        }

        private static Annotation getEncodedAnnotation() {
            @Encoded
            final class EncodedAnnotationTemp {
                EncodedAnnotationTemp() {
                }
            }
            return EncodedAnnotationTemp.class.getAnnotation(Encoded.class);
        }

        @Override
        public Object apply(ContainerRequest request) {
            if (MediaTypes.typeEqual(MediaType.MULTIPART_FORM_DATA_TYPE, request.getMediaType())) {
                return this.multipartProvider.apply(request, this.parameter);
            }
            Form form = FormParamValueProvider.getCachedForm(request, this.decode);
            if (form == null) {
                Form otherForm = FormParamValueProvider.getCachedForm(request, !this.decode);
                form = otherForm != null ? this.switchUrlEncoding(request, otherForm) : this.getForm(request);
                this.cacheForm(request, form);
            }
            try {
                return this.extractor.extract(form.asMap());
            }
            catch (ExtractorException e) {
                throw new ParamException.FormParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }

        private Form switchUrlEncoding(ContainerRequest request, Form otherForm) {
            Set entries = otherForm.asMap().entrySet();
            NullableMultivaluedHashMap<String, String> formMap = new NullableMultivaluedHashMap<String, String>();
            for (Map.Entry entry : entries) {
                String charsetName = ReaderWriter.getCharset(MediaType.valueOf(request.getHeaderString("Content-Type"))).name();
                try {
                    String key = this.decode ? URLDecoder.decode((String)entry.getKey(), charsetName) : URLEncoder.encode((String)entry.getKey(), charsetName);
                    for (String value : (List)entry.getValue()) {
                        if (value != null) {
                            formMap.add(key, this.decode ? URLDecoder.decode(value, charsetName) : URLEncoder.encode(value, charsetName));
                            continue;
                        }
                        formMap.add(key, null);
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    throw new ProcessingException(LocalizationMessages.ERROR_UNSUPPORTED_ENCODING(charsetName, this.extractor.getName()), uee);
                }
            }
            return new Form(formMap);
        }

        private void cacheForm(ContainerRequest request, Form form) {
            request.setProperty(this.decode ? "jersey.config.server.representation.decoded.form" : "jersey.config.server.representation.form", form);
        }

        private Form getForm(ContainerRequest request) {
            return this.getFormParameters(FormParamValueProvider.ensureValidRequest(request));
        }

        private Form getFormParameters(ContainerRequest request) {
            if (MediaTypes.typeEqual(MediaType.APPLICATION_FORM_URLENCODED_TYPE, request.getMediaType())) {
                Form form;
                request.bufferEntity();
                if (this.decode) {
                    form = request.readEntity(Form.class);
                } else {
                    Annotation[] annotations = new Annotation[]{encodedAnnotation};
                    form = request.readEntity(Form.class, annotations);
                }
                return form == null ? new Form() : form;
            }
            return new Form();
        }
    }
}

