/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.NoninvertibleTransformException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.css.impl.SvgNodeRendererInheritanceResolver;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.SvgTagSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.SymbolSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgTextUtil;
import org.slf4j.LoggerFactory;

public class UseSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            String normalizedName;
            String elementToReUse = this.getAttribute("href");
            if (elementToReUse == null) {
                elementToReUse = this.getAttribute("xlink:href");
            }
            if (elementToReUse != null && !elementToReUse.isEmpty() && this.isValidHref(elementToReUse) && !context.isIdUsedByUseTagBefore(normalizedName = SvgTextUtil.filterReferenceValue(elementToReUse))) {
                ISvgNodeRenderer template = context.getNamedObject(normalizedName);
                ISvgNodeRenderer clonedObject = template == null ? null : template.createDeepCopy();
                SvgNodeRendererInheritanceResolver.applyInheritanceToSubTree(this, clonedObject, context.getCssContext());
                if (clonedObject != null) {
                    PdfCanvas currentCanvas = context.getCurrentCanvas();
                    float x = this.parseHorizontalLength(this.getAttribute("x"), context);
                    float y = this.parseVerticalLength(this.getAttribute("y"), context);
                    AffineTransform inverseMatrix = null;
                    if (!CssUtils.compareFloats((float)x, (float)0.0f) || !CssUtils.compareFloats((float)y, (float)0.0f)) {
                        AffineTransform translation = AffineTransform.getTranslateInstance((double)x, (double)y);
                        currentCanvas.concatMatrix(translation);
                        if (this.getParentClipPath() != null) {
                            try {
                                inverseMatrix = translation.createInverse();
                            }
                            catch (NoninvertibleTransformException ex) {
                                LoggerFactory.getLogger(UseSvgNodeRenderer.class).warn("Non-invertible transformation matrix was used in a clipping path context. Clipped elements may show undefined behavior.", (Throwable)ex);
                            }
                        }
                    }
                    clonedObject.setParent(this);
                    if (clonedObject instanceof SvgTagSvgNodeRenderer || clonedObject instanceof SymbolSvgNodeRenderer) {
                        if (this.getAttribute("width") != null) {
                            float width = this.parseHorizontalLength(this.getAttribute("width"), context);
                            clonedObject.setAttribute("width", Float.toString(width) + "pt");
                        }
                        if (this.getAttribute("height") != null) {
                            float height = this.parseVerticalLength(this.getAttribute("height"), context);
                            clonedObject.setAttribute("height", Float.toString(height) + "pt");
                        }
                    }
                    clonedObject.draw(context);
                    clonedObject.setParent(null);
                    if (inverseMatrix != null) {
                        currentCanvas.concatMatrix(inverseMatrix);
                    }
                }
            }
        }
    }

    @Override
    void postDraw(SvgDrawContext context) {
    }

    private boolean isValidHref(String name) {
        return name.startsWith("#");
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        UseSvgNodeRenderer copy = new UseSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        return null;
    }
}

