/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.Image;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;

public class ImageCssApplier {
    public Image apply(Image img, Tag tag) {
        String after;
        String heightValue;
        String widthValue = tag.getCSS().get("width");
        if (widthValue == null) {
            widthValue = tag.getAttributes().get("width");
        }
        if ((heightValue = tag.getCSS().get("height")) == null) {
            heightValue = tag.getAttributes().get("height");
        }
        if (widthValue == null) {
            img.setScaleToFitLineWhenOverflow(true);
        } else {
            img.setScaleToFitLineWhenOverflow(false);
        }
        if (heightValue == null) {
            img.setScaleToFitHeight(true);
        } else {
            img.setScaleToFitHeight(false);
        }
        CssUtils utils = CssUtils.getInstance();
        float widthInPoints = utils.parsePxInCmMmPcToPt(widthValue);
        float heightInPoints = utils.parsePxInCmMmPcToPt(heightValue);
        if (widthInPoints > 0.0f && heightInPoints > 0.0f) {
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (widthInPoints > 0.0f) {
            heightInPoints = img.getHeight() * widthInPoints / img.getWidth();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (heightInPoints > 0.0f) {
            widthInPoints = img.getWidth() * heightInPoints / img.getHeight();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        }
        String before = tag.getCSS().get("before");
        if (before != null) {
            img.setSpacingBefore(Float.parseFloat(before));
        }
        if ((after = tag.getCSS().get("after")) != null) {
            img.setSpacingAfter(Float.parseFloat(after));
        }
        img.setWidthPercentage(0.0f);
        return img;
    }
}

