/*
 * Decompiled with CFR 0.152.
 */
package com.lesfurets.jenkins.unit.global.lib;

import com.lesfurets.jenkins.unit.global.lib.LibraryLoader;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.syntax.SyntaxException;

public class LibraryAnnotationTransformer
extends CompilationCustomizer
implements GroovyObject {
    private static final String LIBRARY_ANNOTATION_CLASS_NAME = "Library";
    private final LibraryLoader libraryLoader;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public LibraryAnnotationTransformer(LibraryLoader libraryLoader) {
        super(CompilePhase.CONVERSION);
        LibraryLoader libraryLoader2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.libraryLoader = libraryLoader2 = libraryLoader;
    }

    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        Reference source2 = new Reference((Object)source);
        Reference libraryAnnotations = new Reference(new HashMap());
        try {
            this.libraryLoader.loadImplicitLibraries();
        }
        catch (Exception e) {
            ((SourceUnit)source2.get()).addException(e);
        }
        new GroovyObject(this, source2, libraryAnnotations){
            public /* synthetic */ Reference libraryAnnotations;
            public /* synthetic */ Reference source;
            public /* synthetic */ LibraryAnnotationTransformer this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                LibraryAnnotationTransformer libraryAnnotationTransformer;
                this.this$0 = libraryAnnotationTransformer = p0;
                this.libraryAnnotations = reference2 = p2;
                this.source = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            protected SourceUnit getSourceUnit() {
                return (SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.source.get(), SourceUnit.class);
            }

            public void visitAnnotations(AnnotatedNode node) {
                super.visitAnnotations(node);
                AnnotationNode annotationNode = null;
                Iterator iterator = node.getAnnotations().iterator();
                while (iterator.hasNext()) {
                    annotationNode = (AnnotationNode)ScriptBytecodeAdapter.castToType(iterator.next(), AnnotationNode.class);
                    String name = annotationNode.getClassNode().getName();
                    if (!ScriptBytecodeAdapter.compareEqual((Object)name, (Object)LIBRARY_ANNOTATION_CLASS_NAME)) continue;
                    Expression value = annotationNode.getMember("value");
                    if (value instanceof ConstantExpression) {
                        ((HashMap)this.libraryAnnotations.get()).put(ShortTypeHandling.castToString((Object)((ConstantExpression)ScriptBytecodeAdapter.castToType((Object)value, ConstantExpression.class)).getValue()), annotationNode);
                        continue;
                    }
                    Expression element = null;
                    Iterator iterator2 = ((ListExpression)ScriptBytecodeAdapter.castToType((Object)value, ListExpression.class)).getExpressions().iterator();
                    while (iterator2.hasNext()) {
                        element = (Expression)ScriptBytecodeAdapter.castToType(iterator2.next(), Expression.class);
                        ((HashMap)this.libraryAnnotations.get()).put(ShortTypeHandling.castToString((Object)((ConstantExpression)ScriptBytecodeAdapter.castToType((Object)element, ConstantExpression.class)).getValue()), annotationNode);
                    }
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$3(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, LibraryAnnotationTransformer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$3(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, LibraryAnnotationTransformer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$3(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, LibraryAnnotationTransformer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }.visitClass(classNode);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class _call_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference source;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _call_closure1(Object _outerInstance, Object _thisObject, Reference source) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.source = reference = source;
            }

            public Object doCall(Map.Entry<String, AnnotationNode> it) {
                AnnotationNode annotation = (AnnotationNode)ScriptBytecodeAdapter.castToType((Object)it.getValue(), AnnotationNode.class);
                String expression = ShortTypeHandling.castToString((Object)it.getKey());
                ((LibraryAnnotationTransformer)((Object)this.getThisObject())).libraryLoader.loadLibrary(expression);
                Object var4_4 = null;
                try {
                    return var4_4;
                }
                catch (Exception e) {
                    ((SourceUnit)this.source.get()).addError(new SyntaxException(e.getMessage(), annotation.getLineNumber(), annotation.getColumnNumber()));
                    Object var6_6 = null;
                    return var6_6;
                }
            }

            public Object call(Map.Entry<String, AnnotationNode> it) {
                return this.doCall(it);
            }

            public SourceUnit getSource() {
                return (SourceUnit)ScriptBytecodeAdapter.castToType((Object)this.source.get(), SourceUnit.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _call_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        ((HashMap)libraryAnnotations.get()).entrySet().forEach((Consumer)ScriptBytecodeAdapter.castToType((Object)((Object)new _call_closure1((Object)this, (Object)this, source2)), Consumer.class));
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LibraryAnnotationTransformer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, LibraryAnnotationTransformer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(LibraryAnnotationTransformer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != LibraryAnnotationTransformer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

