/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.log4j;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.xml.DOMConfigurator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Log4JUtil {
    private static Map<String, String> _customLogSettings = new ConcurrentHashMap<String, String>();
    private static String _liferayHome;

    public static void configureLog4J(ClassLoader classLoader) {
        Log4JUtil.configureLog4J(classLoader.getResource("META-INF/portal-log4j.xml"));
        try {
            Enumeration<URL> enu = classLoader.getResources("META-INF/portal-log4j-ext.xml");
            while (enu.hasMoreElements()) {
                Log4JUtil.configureLog4J(enu.nextElement());
            }
        }
        catch (IOException ioe) {
            Logger logger = Logger.getLogger(Log4JUtil.class.getName());
            logger.log(Level.WARNING, "Unable to load portal-log4j-ext.xml", ioe);
        }
        if (ServerDetector.isJBoss5()) {
            org.apache.log4j.Logger rootLogger = LogManager.getRootLogger();
            Enumeration enu = rootLogger.getAllAppenders();
            while (enu.hasMoreElements()) {
                Appender appender = (Appender)enu.nextElement();
                if (!(appender instanceof WriterAppender)) continue;
                WriterAppender writerAppender = (WriterAppender)appender;
                writerAppender.activateOptions();
            }
        }
    }

    public static void configureLog4J(URL url) {
        if (url == null) {
            return;
        }
        String urlContent = Log4JUtil._getURLContent(url);
        if (urlContent == null) {
            return;
        }
        DOMConfigurator domConfigurator = new DOMConfigurator();
        StringReader urlReader = new StringReader(urlContent);
        domConfigurator.doConfigure((Reader)urlReader, LogManager.getLoggerRepository());
        HashSet<String> currentLoggerNames = new HashSet<String>();
        Enumeration enu = LogManager.getCurrentLoggers();
        while (enu.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)enu.nextElement();
            currentLoggerNames.add(logger.getName());
        }
        try {
            SAXReader saxReader = new SAXReader();
            StringReader reader = new StringReader(urlContent);
            Document document = saxReader.read((Reader)reader, url.toExternalForm());
            Element rootElement = document.getRootElement();
            List categoryElements = rootElement.elements("category");
            for (Element categoryElement : categoryElements) {
                String name = categoryElement.attributeValue("name");
                Element priorityElement = categoryElement.element("priority");
                String priority = priorityElement.attributeValue("value");
                Log4JUtil.setLevel(name, priority, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getCustomLogSettings() {
        return new HashMap<String, String>(_customLogSettings);
    }

    public static String getOriginalLevel(String className) {
        org.apache.log4j.Level level = org.apache.log4j.Level.ALL;
        Enumeration enu = LogManager.getCurrentLoggers();
        while (enu.hasMoreElements()) {
            org.apache.log4j.Logger logger = (org.apache.log4j.Logger)enu.nextElement();
            if (!className.equals(logger.getName())) continue;
            level = logger.getLevel();
            break;
        }
        return level.toString();
    }

    public static void initLog4J(String serverId, String liferayHome, ClassLoader classLoader, LogFactory logFactory, Map<String, String> customLogSettings) {
        ServerDetector.init((String)serverId);
        _liferayHome = liferayHome;
        Log4JUtil.configureLog4J(classLoader);
        try {
            LogFactoryUtil.setLogFactory((LogFactory)logFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String name : customLogSettings.keySet()) {
            String priority = customLogSettings.get(name);
            Log4JUtil.setLevel(name, priority, false);
        }
    }

    public static void setLevel(String name, String priority, boolean custom) {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)name);
        logger.setLevel(org.apache.log4j.Level.toLevel((String)priority));
        Logger jdkLogger = Logger.getLogger(name);
        jdkLogger.setLevel(Log4JUtil._getJdkLevel(priority));
        if (custom) {
            _customLogSettings.put(name, priority);
        }
    }

    private static byte[] _getBytes(InputStream inputStream) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)unsyncByteArrayOutputStream, (int)-1, (boolean)true);
        return unsyncByteArrayOutputStream.toByteArray();
    }

    private static Level _getJdkLevel(String priority) {
        if (priority.equalsIgnoreCase(org.apache.log4j.Level.DEBUG.toString())) {
            return Level.FINE;
        }
        if (priority.equalsIgnoreCase(org.apache.log4j.Level.ERROR.toString())) {
            return Level.SEVERE;
        }
        if (priority.equalsIgnoreCase(org.apache.log4j.Level.WARN.toString())) {
            return Level.WARNING;
        }
        return Level.INFO;
    }

    private static String _getLiferayHome() {
        if (_liferayHome == null) {
            _liferayHome = PropsUtil.get((String)"liferay.home");
        }
        return _liferayHome;
    }

    private static String _getURLContent(URL url) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("liferay.home", Log4JUtil._getLiferayHome());
        String urlContent = null;
        InputStream inputStream = null;
        try {
            try {
                inputStream = url.openStream();
                byte[] bytes = Log4JUtil._getBytes(inputStream);
                urlContent = new String(bytes, "UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
                StreamUtil.cleanUp((InputStream)inputStream);
                return null;
            }
        }
        finally {
            StreamUtil.cleanUp((InputStream)inputStream);
        }
        for (Map.Entry variable : variables.entrySet()) {
            urlContent = urlContent.replaceAll("@" + (String)variable.getKey() + "@", (String)variable.getValue());
        }
        if (ServerDetector.getServerId() != null) {
            return urlContent;
        }
        int x = urlContent.indexOf("<appender name=\"FILE\"");
        int y = urlContent.indexOf("</appender>", x);
        if (y != -1) {
            y = urlContent.indexOf("<", y + 1);
        }
        if (x != -1 && y != -1) {
            urlContent = String.valueOf(urlContent.substring(0, x)) + urlContent.substring(y);
        }
        urlContent = StringUtil.replace((String)urlContent, (String)"<appender-ref ref=\"FILE\" />", (String)"");
        return urlContent;
    }
}

