/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.sdk.raas.api;

import com.loginradius.sdk.raas.api.RaaSAPI;
import com.loginradius.sdk.raas.models.LoginRadiusPresenceResponse;
import com.loginradius.sdk.raas.models.RaaSHashPassword;
import com.loginradius.sdk.raas.models.RaaSResponse;
import com.loginradius.sdk.raas.models.RaaSUserDetails;
import com.loginradius.sdk.social.core.LoginRadiusClient;
import com.loginradius.sdk.util.ArgumentValidator;
import java.util.HashMap;

public class AccountAPI
extends RaaSAPI {
    public RaaSResponse setAccountPassword(String accountid, String password) {
        if (ArgumentValidator.isEmpty(accountid) || ArgumentValidator.isEmpty(password)) {
            throw new IllegalArgumentException("Accountid/password cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountid", accountid);
        params.put("action", "set");
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("password", password);
        String jsonResponse = this.executePost("/raas/v1/account/password", params, postParams);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSResponse changeUserName(String accountId, String oldusername, String newusername) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountId", accountId);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("oldusername", oldusername);
        postParams.put("newusername", newusername);
        String jsonResponse = this.executePost("/raas/v1/account/changeusername", params, postParams);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public LoginRadiusPresenceResponse checkUserNameAvailablity(String username) {
        if (ArgumentValidator.isEmpty(username)) {
            throw new IllegalArgumentException("Username cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        String jsonResponse = this.executeGet("/raas/v1/user/checkusername", params);
        return LoginRadiusClient.formatResponse(jsonResponse, LoginRadiusPresenceResponse.class);
    }

    public RaaSResponse setUserName(String accountId, String newusername) {
        if (ArgumentValidator.isEmpty(accountId) || ArgumentValidator.isEmpty(newusername)) {
            throw new IllegalArgumentException("AccountId/oldPassword/newPassword cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountId", accountId);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("newusername", newusername);
        String jsonResponse = this.executePost("/raas/v1/account/setusername", params, postParams);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSResponse changeAccountPassword(String accountId, String oldPassword, String newPassword) {
        if (ArgumentValidator.isEmpty(accountId) || ArgumentValidator.isEmpty(oldPassword) || ArgumentValidator.isEmpty(newPassword)) {
            throw new IllegalArgumentException("AccountId/oldPassword/newPassword cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountid", accountId);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("oldpassword", oldPassword);
        postParams.put("newpassword", newPassword);
        String jsonResponse = this.executePost("/raas/v1/account/password", params, postParams);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSResponse linkAccount(String accountId, String provider, String providerId) {
        if (ArgumentValidator.isEmpty(accountId) || ArgumentValidator.isEmpty(providerId) || ArgumentValidator.isEmpty(provider)) {
            throw new IllegalArgumentException("AccountId/providerId/provider cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountid", accountId);
        params.put("provider", provider);
        params.put("providerid", providerId);
        String jsonResponse = this.executePost("/raas/v1/account/link", null, params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSResponse unlinkAccount(String accountId, String provider, String providerId) {
        if (ArgumentValidator.isEmpty(accountId) || ArgumentValidator.isEmpty(providerId) || ArgumentValidator.isEmpty(provider)) {
            throw new IllegalArgumentException("AccountId/providerId/provider cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountid", accountId);
        params.put("provider", provider);
        params.put("providerid", providerId);
        String jsonResponse = this.executePost("/raas/v1/account/unlink", null, params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSUserDetails[] getAllProfilesFromAccount(String accountId) {
        if (ArgumentValidator.isEmpty(accountId)) {
            throw new IllegalArgumentException("AccountId cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountid", accountId);
        String jsonResponse = this.executeGet("/raas/v1/account", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSUserDetails[].class);
    }

    public RaaSHashPassword getHashPassword(String accountId) {
        if (ArgumentValidator.isEmpty(accountId)) {
            throw new IllegalArgumentException("AccountId cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountid", accountId);
        String jsonResponse = this.executeGet("/raas/v1/account/password", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSHashPassword.class);
    }

    public RaaSResponse setAccountStatus(String accountId, boolean isBlock) {
        if (ArgumentValidator.isEmpty(accountId)) {
            throw new IllegalArgumentException("AccountId cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountid", accountId);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("isblock", isBlock ? "true" : "false");
        String jsonResponse = this.executePost("/raas/v1/account/status", params, postParams);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSResponse deleteAccount(String accountId) {
        if (ArgumentValidator.isEmpty(accountId)) {
            throw new IllegalArgumentException("accountId cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountid", accountId);
        String jsonResponse = this.executeGet("/raas/v1/account/delete", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSResponse deleteAccountWithEmailConfirmation(String accountId, String deleteUserLink, String template) {
        if (ArgumentValidator.isEmpty(accountId) || ArgumentValidator.isEmpty(deleteUserLink)) {
            throw new IllegalArgumentException("accountId/DeleteUserLink cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountid", accountId);
        params.put("deleteUserLink", deleteUserLink);
        params.put("template", template);
        String jsonResponse = this.executeGet("/raas/v1/account/deleteuseremail", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }
}

