/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.sdk.raas.api;

import com.loginradius.sdk.raas.api.RaaSAPI;
import com.loginradius.sdk.raas.models.LoginRadiusPresenceResponse;
import com.loginradius.sdk.raas.models.RaaSCustomObjectResponse;
import com.loginradius.sdk.raas.models.RaaSCustomObjectStats;
import com.loginradius.sdk.raas.models.RaaSResponse;
import com.loginradius.sdk.social.core.LoginRadiusClient;
import java.util.HashMap;

public class CustomObjectAPI
extends RaaSAPI {
    public RaaSResponse objectCreateUpdate(String accountid, String objectId, String customObject) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectid", objectId);
        params.put("accountid", accountid);
        String jsonResponse = this.executePost("/raas/v1/user/customObject/upsert", params, customObject);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSCustomObjectResponse[] getObjectByAccountIds(String objectId, String accountIds) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectid", objectId);
        params.put("accountids", accountIds);
        String jsonResponse = this.executeGet("/raas/v1/user/customObject", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSCustomObjectResponse[].class);
    }

    public RaaSCustomObjectResponse getObjectByAccountid(String objectId, String accountId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectid", objectId);
        params.put("accountid", accountId);
        String jsonResponse = this.executeGet("/raas/v1/user/customObject", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSCustomObjectResponse.class);
    }

    @Deprecated
    public RaaSCustomObjectResponse[] getObjectByUniqueObjectid(String objectid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectid", objectid);
        String jsonResponse = this.executeGet("/raas/v1/user/customObject", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSCustomObjectResponse[].class);
    }

    public RaaSCustomObjectResponse[] getObjectByQuery(String objectid, String query, String indexvalue) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectid", objectid);
        params.put("q", query);
        params.put("cursor", indexvalue);
        String jsonResponse = this.executeGet("/raas/v1/user/customObject", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSCustomObjectResponse[].class);
    }

    public RaaSCustomObjectResponse[] getObjectByObjectid(String objectid, String indexvalue) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectid", objectid);
        params.put("cursor", indexvalue);
        String jsonResponse = this.executeGet("/raas/v1/user/customObject", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSCustomObjectResponse[].class);
    }

    public RaaSResponse deleteCustomObject(String objectid, String accountId, boolean isBlock) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectid", objectid);
        params.put("accountId", accountId);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("isblock", isBlock ? "TRUE" : "FALSE");
        String jsonResponse = this.executePost("/raas/v1/user/customObject/status", params, postParams);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSCustomObjectStats getCustomObjectStats(String objectid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectid", objectid);
        String jsonResponse = this.executeGet("/raas/v1/user/customObject/stats", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSCustomObjectStats.class);
    }

    public LoginRadiusPresenceResponse checkForCustomObject(String objectid, String accountid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectid", objectid);
        params.put("accountid", accountid);
        String jsonResponse = this.executeGet("/raas/v1/user/customObject/check", params);
        return LoginRadiusClient.formatResponse(jsonResponse, LoginRadiusPresenceResponse.class);
    }
}

