/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.sdk.raas.api;

import com.loginradius.sdk.raas.models.RaaSClientConfig;
import com.loginradius.sdk.social.core.LoginRadiusException;
import com.loginradius.sdk.util.LoginRadiusJsonDeserializer;
import com.loginradius.sdk.util.LoginRadiusRestErrorResponse;
import com.loginradius.sdk.util.RestRequest;
import com.loginradius.sdk.util.RestResponse;
import java.util.HashMap;
import java.util.Map;

public abstract class RaaSAPI {
    protected RestRequest restrequest = new RestRequest();
    protected LoginRadiusJsonDeserializer deserializer = new LoginRadiusJsonDeserializer();

    protected String executeGet(String apiRelativepath, Map<String, String> params) {
        HashMap<String, String> reParams = new HashMap<String, String>();
        reParams.put("appkey", RaaSClientConfig.getConfiguration().getAppKey());
        reParams.put("appsecret", RaaSClientConfig.getConfiguration().getAppSecret());
        if (RaaSClientConfig.getConfiguration().getObjectID() != null) {
            reParams.put("objectid", RaaSClientConfig.getConfiguration().getObjectID());
        }
        if (params != null) {
            reParams.putAll(params);
        }
        RestResponse response = this.restrequest.get(apiRelativepath, reParams);
        String jsonresponse = response.getResponse();
        if (response.getStatusCode() == 200) {
            return jsonresponse;
        }
        LoginRadiusRestErrorResponse error = this.deserializer.deserializeJson(jsonresponse, LoginRadiusRestErrorResponse.class);
        throw new LoginRadiusException(error);
    }

    protected String executePost(String apiRelativepath, Map<String, String> getParams, Map<String, String> postParams) {
        HashMap<String, String> reParams = new HashMap<String, String>();
        reParams.put("appkey", RaaSClientConfig.getConfiguration().getAppKey());
        reParams.put("appsecret", RaaSClientConfig.getConfiguration().getAppSecret());
        if (RaaSClientConfig.getConfiguration().getObjectID() != null) {
            reParams.put("objectid", RaaSClientConfig.getConfiguration().getObjectID());
        }
        if (getParams != null) {
            reParams.putAll(getParams);
        }
        RestResponse response = this.restrequest.post(apiRelativepath, reParams, postParams);
        String jsonresponse = response.getResponse();
        if (response.getStatusCode() == 200) {
            return jsonresponse;
        }
        LoginRadiusRestErrorResponse error = this.deserializer.deserializeJson(jsonresponse, LoginRadiusRestErrorResponse.class);
        throw new LoginRadiusException(error);
    }

    protected String executePost(String apiRelativepath, Map<String, String> getParams, String postParams) {
        HashMap<String, String> reParams = new HashMap<String, String>();
        reParams.put("appkey", RaaSClientConfig.getConfiguration().getAppKey());
        reParams.put("appsecret", RaaSClientConfig.getConfiguration().getAppSecret());
        if (RaaSClientConfig.getConfiguration().getObjectID() != null) {
            reParams.put("objectid", RaaSClientConfig.getConfiguration().getObjectID());
        }
        if (getParams != null) {
            reParams.putAll(getParams);
        }
        RestResponse response = this.restrequest.post(apiRelativepath, reParams, postParams);
        String jsonresponse = response.getResponse();
        if (response.getStatusCode() == 200) {
            return jsonresponse;
        }
        LoginRadiusRestErrorResponse error = this.deserializer.deserializeJson(jsonresponse, LoginRadiusRestErrorResponse.class);
        throw new LoginRadiusException(error);
    }
}

