/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.sdk.raas.api;

import com.loginradius.sdk.raas.api.RaaSAPI;
import com.loginradius.sdk.raas.models.LoginRadiusEmailVerificationTokenResponse;
import com.loginradius.sdk.raas.models.LoginRadiusForgotPasswordResponse;
import com.loginradius.sdk.raas.models.LoginRadiusPresenceResponse;
import com.loginradius.sdk.raas.models.RaaSClientConfig;
import com.loginradius.sdk.raas.models.RaaSResponse;
import com.loginradius.sdk.raas.models.RaaSUserDetails;
import com.loginradius.sdk.social.core.LoginRadiusClient;
import com.loginradius.sdk.social.core.LoginRadiusException;
import com.loginradius.sdk.social.models.AccessToken;
import com.loginradius.sdk.util.ArgumentValidator;
import com.loginradius.sdk.util.LoginRadiusRestErrorResponse;
import com.loginradius.sdk.util.RestResponse;
import java.util.HashMap;

public class UserProfileAPI
extends RaaSAPI {
    public RaaSUserDetails getUserByUserId(String userId) {
        if (ArgumentValidator.isEmpty(userId)) {
            throw new IllegalArgumentException("The input to the method is not correct");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", userId);
        String jsonResponse = this.executeGet("/raas/v1/user", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSUserDetails.class);
    }

    public RaaSUserDetails[] getUserbyEmail(String email) {
        if (ArgumentValidator.isEmpty(email)) {
            throw new IllegalArgumentException("The input to the method is not correct");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("emailid", email);
        String jsonResponse = this.executeGet("/raas/v1/user", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSUserDetails[].class);
    }

    public RaaSUserDetails getUserAfterAuthentication(String UserName, String Password) {
        if (ArgumentValidator.isEmpty(UserName) || ArgumentValidator.isEmpty(Password)) {
            throw new IllegalArgumentException("The input to the method is not correct");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", UserName);
        params.put("password", Password);
        String jsonResponse = this.executeGet("/raas/v1/user", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSUserDetails.class);
    }

    public LoginRadiusPresenceResponse checkEmailAvailability(String emailId) {
        if (ArgumentValidator.isEmpty(emailId)) {
            throw new IllegalArgumentException("The input to the method is not correct");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("emailid", emailId);
        String jsonResponse = this.executeGet("/raas/v1/user/checkemail", params);
        return LoginRadiusClient.formatResponse(jsonResponse, LoginRadiusPresenceResponse.class);
    }

    public LoginRadiusForgotPasswordResponse getForgotPassWordToken(String emailId) {
        if (ArgumentValidator.isEmpty(emailId)) {
            throw new IllegalArgumentException("The input to the method is not correct");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", emailId);
        String jsonResponse = this.executeGet("/raas/v1/account/password/forgot", params);
        return LoginRadiusClient.formatResponse(jsonResponse, LoginRadiusForgotPasswordResponse.class);
    }

    public LoginRadiusEmailVerificationTokenResponse getUserEmailVerificationResend(String emailId, String link, String template) {
        if (ArgumentValidator.isEmpty(emailId) || ArgumentValidator.isEmpty(link)) {
            throw new IllegalArgumentException("The input to the method is not correct");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("emailid", emailId);
        params.put("link", link);
        params.put("template", template);
        String jsonResponse = this.executeGet("/raas/v1/account/verificationemail", params);
        return LoginRadiusClient.formatResponse(jsonResponse, LoginRadiusEmailVerificationTokenResponse.class);
    }

    public AccessToken validateAccessToken(String access_token) {
        if (ArgumentValidator.isEmpty(access_token)) {
            throw new IllegalArgumentException("Access token cannot be empty");
        }
        HashMap<String, String> reParams = new HashMap<String, String>();
        reParams.put("access_token", access_token);
        reParams.put("key", RaaSClientConfig.getConfiguration().getAppKey());
        reParams.put("secret", RaaSClientConfig.getConfiguration().getAppSecret());
        RestResponse response = this.restrequest.get("/api/v2/access_token/Validate", reParams);
        String jsonresponse = response.getResponse();
        System.out.println("RaaSAPI.jsonresponse " + jsonresponse);
        if (response.getStatusCode() != 200) {
            LoginRadiusRestErrorResponse error = this.deserializer.deserializeJson(jsonresponse, LoginRadiusRestErrorResponse.class);
            throw new LoginRadiusException(error);
        }
        return LoginRadiusClient.formatResponse(jsonresponse, AccessToken.class);
    }

    public RaaSResponse invalidateAccessToken(String access_token) {
        if (ArgumentValidator.isEmpty(access_token)) {
            throw new IllegalArgumentException("Access token cannot be empty");
        }
        HashMap<String, String> reParams = new HashMap<String, String>();
        reParams.put("access_token", access_token);
        reParams.put("key", RaaSClientConfig.getConfiguration().getAppKey());
        reParams.put("secret", RaaSClientConfig.getConfiguration().getAppSecret());
        RestResponse response = this.restrequest.get("/api/v2/access_token/invalidate", reParams);
        String jsonresponse = response.getResponse();
        System.out.println("RaaSAPI.jsonresponse " + jsonresponse);
        if (response.getStatusCode() != 200) {
            LoginRadiusRestErrorResponse error = this.deserializer.deserializeJson(jsonresponse, LoginRadiusRestErrorResponse.class);
            throw new LoginRadiusException(error);
        }
        return LoginRadiusClient.formatResponse(jsonresponse, RaaSResponse.class);
    }

    public RaaSResponse editUser(String userId, String userDetails) {
        if (userDetails == null || userDetails.isEmpty()) {
            throw new IllegalArgumentException("User details cannot be empty");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", userId);
        String jsonResponse = this.executePost("/raas/v1/user", params, userDetails);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSResponse userEmailAddRemove(String accountid, String action, String emailid, String emailtype) {
        if (ArgumentValidator.isEmpty(accountid) || ArgumentValidator.isEmpty(action) || ArgumentValidator.isEmpty(emailid) || ArgumentValidator.isEmpty(emailtype)) {
            throw new IllegalArgumentException("The input is not correct.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("accountid", accountid);
        params.put("action", action);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("emailid", emailid);
        postParams.put("emailtype", emailtype);
        String jsonResponse = this.executePost("/raas/v1/account/email", params, postParams);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    @Deprecated
    public RaaSResponse changePassword(String userId, String OldPassword, String NewPassword) {
        if (ArgumentValidator.isEmpty(OldPassword) || ArgumentValidator.isEmpty(NewPassword)) {
            throw new IllegalArgumentException("You cannot provide empty passwords");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", userId);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("oldpassword", OldPassword);
        postParams.put("newpassword", NewPassword);
        String jsonResponse = this.executePost("/raas/v1/user/password", params, postParams);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    @Deprecated
    public RaaSResponse setPassword(String userid, String password) {
        if (ArgumentValidator.isEmpty(userid) || ArgumentValidator.isEmpty(password)) {
            throw new IllegalArgumentException("Invalid input");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "set");
        params.put("userid", userid);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("password", password);
        String jsonResponse = this.executePost("/raas/v1/user/password", params, postParams);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSUserDetails createUser(String userDetails) {
        if (ArgumentValidator.isEmpty(userDetails)) {
            throw new IllegalArgumentException("User Details cannot be empty");
        }
        String jsonResponse = this.executePost("/raas/v1/user", null, userDetails);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSUserDetails.class);
    }

    public RaaSResponse registerUser(String userDetails) {
        if (ArgumentValidator.isEmpty(userDetails)) {
            throw new IllegalArgumentException("User Details cannot be empty");
        }
        String jsonResponse = this.executePost("/raas/v1/user/register", null, userDetails);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSResponse createRegistrationProfile(String emailId, String password, String accountId) {
        if (ArgumentValidator.isEmpty(emailId) || ArgumentValidator.isEmpty(password) || ArgumentValidator.isEmpty(accountId)) {
            throw new IllegalArgumentException("Invalid input");
        }
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("accountid", accountId);
        postParams.put("emailid", emailId);
        postParams.put("password", password);
        String jsonResponse = this.executePost("raas/v1/account/profile", null, postParams);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }

    public RaaSResponse deleteUserWithEmailConfirmation(String userid, String deleteuserlink, String template) {
        if (ArgumentValidator.isEmpty(userid) || ArgumentValidator.isEmpty(deleteuserlink)) {
            throw new IllegalArgumentException("Invalid input");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", userid);
        params.put("deleteuserlink", deleteuserlink);
        params.put("template", template);
        String jsonResponse = this.executeGet("/raas/v1/user/deleteuseremail", params);
        return LoginRadiusClient.formatResponse(jsonResponse, RaaSResponse.class);
    }
}

