/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.sdk.social.core;

import com.loginradius.sdk.social.core.LoginRadiusException;
import com.loginradius.sdk.social.models.AccessToken;
import com.loginradius.sdk.util.LoginRadiusJsonDeserializer;
import com.loginradius.sdk.util.LoginRadiusRestErrorResponse;
import com.loginradius.sdk.util.RestRequest;
import com.loginradius.sdk.util.RestResponse;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class LoginRadiusCallbackHelper {
    private String secret;
    RestRequest restrequest = new RestRequest();
    LoginRadiusJsonDeserializer deserializer = new LoginRadiusJsonDeserializer();

    public LoginRadiusCallbackHelper(String secret) {
        this.secret = secret;
    }

    public AccessToken GetLoginRadiusToken(HttpServletRequest request) {
        if (request.getMethod().equalsIgnoreCase("POST")) {
            String request_token = request.getParameter("token");
            if (request_token != null && !request_token.isEmpty()) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("token", request_token);
                params.put("secret", this.secret);
                RestResponse response = this.restrequest.get("/api/v2/access_token", params);
                String jsonresponse = response.getResponse();
                if (response.getStatusCode() == 200) {
                    return this.deserializer.deserializeJson(jsonresponse, AccessToken.class);
                }
                LoginRadiusRestErrorResponse error = this.deserializer.deserializeJson(jsonresponse, LoginRadiusRestErrorResponse.class);
                throw new LoginRadiusException(error);
            }
            throw new LoginRadiusException("LoginRadius request not contains Loginradius valid request token");
        }
        throw new LoginRadiusException("LoginRadius callback handler work with HTTP Post Request only.");
    }
}

