/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.sdk.social.core;

import java.util.Map;

public class LoginRadiusEndpoint {
    private static final String LOGINRADIUS_API_ROOT = "https://api.loginradius.com";

    public static String getRequestUrl(String relativeUrl) {
        if (relativeUrl.startsWith("/")) {
            return LOGINRADIUS_API_ROOT + relativeUrl;
        }
        return "https://api.loginradius.com/" + relativeUrl;
    }

    public static String getRequestUrl(String relativeUrl, Map<String, String> queryArgs) {
        String keyvalueString = LoginRadiusEndpoint.createKeyValueString(queryArgs);
        String url = LoginRadiusEndpoint.getRequestUrl(relativeUrl);
        if (url.contains("?")) {
            return url + "&" + keyvalueString;
        }
        return url + "?" + keyvalueString;
    }

    public static String createKeyValueString(Map<String, String> queryArgs) {
        if (queryArgs != null) {
            String[] sb = new String[queryArgs.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : queryArgs.entrySet()) {
                sb[i] = entry.getKey() + "=" + entry.getValue();
                ++i;
            }
            return LoginRadiusEndpoint.combine(sb, "&");
        }
        return "";
    }

    public static String combine(String[] s, String glue) {
        int k = s.length;
        if (k == 0) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        out.append(s[0]);
        for (int x = 1; x < k; ++x) {
            out.append(glue).append(s[x]);
        }
        return out.toString();
    }
}

