/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.time;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.time.MutableInterval;
import com.mastfrog.util.time.ReadableInterval;
import com.mastfrog.util.time.TimeUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;

public abstract class Interval
implements ReadableInterval {
    @Override
    public Interval toInterval() {
        return this;
    }

    @Override
    public long getStartMillis() {
        return this.start().toEpochMilli();
    }

    @Override
    public long getEndMillis() {
        return this.end().toEpochMilli();
    }

    @Override
    public long toDurationMillis() {
        return this.getEndMillis() - this.getStartMillis();
    }

    @Override
    public boolean overlaps(ReadableInterval other) {
        return this.overlaps(other.start()) || this.overlaps(other.end());
    }

    @Override
    public boolean abuts(ReadableInterval other) {
        return this.start().equals(other.end()) || this.end().equals(other.start());
    }

    @Override
    public Duration toDuration() {
        return Duration.between(this.start(), this.end());
    }

    @Override
    public boolean overlaps(ChronoZonedDateTime when) {
        return this.overlaps(when.toInstant());
    }

    @Override
    public boolean contains(Instant instant) {
        return instant.equals(this.start()) || instant.isAfter(this.start()) && instant.isBefore(this.end());
    }

    @Override
    public boolean isBefore(Instant instant) {
        return this.end().isBefore(instant);
    }

    @Override
    public boolean isAfter(Instant instant) {
        return this.start().isAfter(instant);
    }

    @Override
    public boolean isBefore(ReadableInterval interval) {
        return this.end().isBefore(interval.start());
    }

    @Override
    public boolean isAfter(ReadableInterval interval) {
        return this.start().isAfter(interval.end());
    }

    @Override
    public ZonedDateTime startTime() {
        Instant start = this.start();
        return ZonedDateTime.ofInstant(start, ZoneId.systemDefault());
    }

    @Override
    public ZonedDateTime endTime() {
        Instant end = this.end();
        return ZonedDateTime.ofInstant(end, ZoneId.systemDefault());
    }

    @Override
    public boolean overlaps(Instant instant) {
        Instant start = this.start();
        Instant end = this.end();
        return start.equals(instant) || end.equals(instant) || start.isBefore(instant) && end.isAfter(instant);
    }

    @Override
    public boolean contains(ReadableInterval other) {
        return other.start().isAfter(this.start()) && other.end().isBefore(this.end());
    }

    public static Interval create(ChronoZonedDateTime<?> start, ChronoZonedDateTime<?> end) {
        Checks.notNull((String)"start", start);
        Checks.notNull((String)"end", end);
        return Interval.create(start.toInstant(), end.toInstant());
    }

    public static Interval create(Duration dur, ChronoZonedDateTime<?> end) {
        Temporal start = end.minus(dur);
        return Interval.create(start, end);
    }

    public static Interval create(ChronoZonedDateTime<?> start, Duration dur) {
        Temporal end = start.plus(dur);
        return Interval.create(start, end);
    }

    public static Interval create(long startMillisEpoch, long endMillisEpoch) {
        return Interval.create(Instant.ofEpochMilli(startMillisEpoch), Instant.ofEpochMilli(endMillisEpoch));
    }

    public static Interval create(Instant start, Instant end) {
        if (end.isBefore(start)) {
            Instant tmp = end;
            end = start;
            start = tmp;
        }
        return new ImmutableInterval(start, end);
    }

    public int hashCode() {
        return this.start().hashCode() + 73 * this.end().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Interval) {
            Interval i = (Interval)o;
            return this.getStartMillis() == i.getStartMillis() && this.getEndMillis() == i.getEndMillis();
        }
        return false;
    }

    public String toString() {
        return TimeUtil.format(this.toDuration()) + " from " + DateTimeFormatter.ISO_INSTANT.format(this.start()) + " to " + DateTimeFormatter.ISO_INSTANT.format(this.end());
    }

    @Override
    public Interval overlap(ReadableInterval interval) {
        if (this.overlaps(interval)) {
            Instant sa = this.start();
            Instant sb = interval.start();
            Instant ea = this.end();
            Instant eb = interval.end();
            Instant st = sa.isAfter(sb) ? sa : sb;
            Instant en = eb.isAfter(sb) ? ea : sa;
            return Interval.create(st, en);
        }
        return null;
    }

    @Override
    public MutableInterval toMutableInterval() {
        return new MutableInterval(this.start(), this.end());
    }

    @Override
    public boolean isEmpty() {
        return this.toDuration().toMillis() == 0L;
    }

    @Override
    public Interval gap(ReadableInterval interval) {
        if (this.overlaps(interval)) {
            Interval ol = this.overlap(interval);
            return new ImmutableInterval(ol.start(), ol.start());
        }
        Instant sa = this.start();
        Instant sb = interval.start();
        Instant ea = this.end();
        Instant eb = interval.end();
        Instant en = sa.isAfter(ea) ? sa : sb;
        Instant st = en == sa ? eb : ea;
        return Interval.create(st, en);
    }

    @Override
    public Interval withStartMillis(long startInstant) {
        return Interval.create(startInstant, this.getEndMillis());
    }

    @Override
    public Interval withStart(Instant start) {
        return Interval.create(start, this.end());
    }

    @Override
    public Interval withEndMillis(long endInstant) {
        return Interval.create(this.getStartMillis(), endInstant);
    }

    @Override
    public Interval withEnd(Instant end) {
        return Interval.create(this.start(), end);
    }

    private static final class ImmutableInterval
    extends Interval {
        private final Instant start;
        private final Instant end;

        public ImmutableInterval(Instant start, Instant end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public Instant start() {
            return this.start;
        }

        @Override
        public Instant end() {
            return this.end;
        }

        @Override
        public MutableInterval toMutableInterval() {
            return new MutableInterval(this.start, this.end);
        }
    }
}

