// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

package com.microsoft.aad.msal4j;

import java.util.Objects;

final class ClientSecret implements IClientSecret {

    private final String clientSecret;

    /**
     * Constructor to create credential with client id and secret
     *
     * @param clientSecret Secret of the client requesting the token.
     */
    ClientSecret(final String clientSecret) {
        if (StringHelper.isBlank(clientSecret)) {
            throw new IllegalArgumentException("clientSecret is null or empty");
        }

        this.clientSecret = clientSecret;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    //These methods are based on those generated by Lombok's @EqualsAndHashCode annotation.
    //They have the same functionality as the generated methods, but were refactored for readability.
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ClientSecret)) return false;

        ClientSecret other = (ClientSecret) o;
        return Objects.equals(clientSecret, other.clientSecret);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 59 + (this.clientSecret == null ? 43 : this.clientSecret.hashCode());
        return result;
    }
}
