// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.KeyValuePair;
import com.microsoft.graph.identitygovernance.models.LifecycleTaskCategory;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Task.
 */
public class Task extends Entity implements IJsonBackedObject {


    /**
     * The Arguments.
     * Arguments included within the task.  For guidance to configure this property, see Configure the arguments for built-in Lifecycle Workflow tasks. Required.
     */
    @SerializedName(value = "arguments", alternate = {"Arguments"})
    @Expose
	@Nullable
    public java.util.List<KeyValuePair> arguments;

    /**
     * The Category.
     * The category of the task. The possible values are: joiner, leaver, unknownFutureValue. This property is multi-valued and the same task can apply to both joiner and leaver categories.Supports $filter(eq, ne).
     */
    @SerializedName(value = "category", alternate = {"Category"})
    @Expose
	@Nullable
    public EnumSet<LifecycleTaskCategory> category;

    /**
     * The Continue On Error.
     * A boolean value that specifies whether, if this task fails, the workflow will stop, and subsequent tasks will not run. Optional.
     */
    @SerializedName(value = "continueOnError", alternate = {"ContinueOnError"})
    @Expose
	@Nullable
    public Boolean continueOnError;

    /**
     * The Description.
     * A string that describes the purpose of the task for administrative use. Optional.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * A unique string that identifies the task. Required.Supports $filter(eq, ne) and orderBy.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Execution Sequence.
     * An integer that states in what order the task will run in a workflow.Supports $orderby.
     */
    @SerializedName(value = "executionSequence", alternate = {"ExecutionSequence"})
    @Expose
	@Nullable
    public Integer executionSequence;

    /**
     * The Is Enabled.
     * A boolean value that denotes whether the task is set to run or not. Optional.Supports $filter(eq, ne) and orderBy.
     */
    @SerializedName(value = "isEnabled", alternate = {"IsEnabled"})
    @Expose
	@Nullable
    public Boolean isEnabled;

    /**
     * The Task Definition Id.
     * A unique template identifier for the task. For more information about the tasks that Lifecycle Workflows currently supports and their unique identifiers, see supported tasks. Required.Supports $filter(eq, ne).
     */
    @SerializedName(value = "taskDefinitionId", alternate = {"TaskDefinitionId"})
    @Expose
	@Nullable
    public String taskDefinitionId;

    /**
     * The Task Processing Results.
     * The result of processing the task.
     */
    @SerializedName(value = "taskProcessingResults", alternate = {"TaskProcessingResults"})
    @Expose
	@Nullable
    public com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionPage taskProcessingResults;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("taskProcessingResults")) {
            taskProcessingResults = serializer.deserializeObject(json.get("taskProcessingResults"), com.microsoft.graph.identitygovernance.requests.TaskProcessingResultCollectionPage.class);
        }
    }
}
