// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AllowedValue;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Allowed Value Request.
 */
public class AllowedValueRequest extends BaseRequest<AllowedValue> {
	
    /**
     * The request for the AllowedValue
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AllowedValueRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AllowedValue.class);
    }

    /**
     * Gets the AllowedValue from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AllowedValue> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AllowedValue from the service
     *
     * @return the AllowedValue from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AllowedValue get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AllowedValue> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AllowedValue delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AllowedValue with a source
     *
     * @param sourceAllowedValue the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AllowedValue> patchAsync(@Nonnull final AllowedValue sourceAllowedValue) {
        return sendAsync(HttpMethod.PATCH, sourceAllowedValue);
    }

    /**
     * Patches this AllowedValue with a source
     *
     * @param sourceAllowedValue the source object with updates
     * @return the updated AllowedValue
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AllowedValue patch(@Nonnull final AllowedValue sourceAllowedValue) throws ClientException {
        return send(HttpMethod.PATCH, sourceAllowedValue);
    }

    /**
     * Creates a AllowedValue with a new object
     *
     * @param newAllowedValue the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AllowedValue> postAsync(@Nonnull final AllowedValue newAllowedValue) {
        return sendAsync(HttpMethod.POST, newAllowedValue);
    }

    /**
     * Creates a AllowedValue with a new object
     *
     * @param newAllowedValue the new object to create
     * @return the created AllowedValue
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AllowedValue post(@Nonnull final AllowedValue newAllowedValue) throws ClientException {
        return send(HttpMethod.POST, newAllowedValue);
    }

    /**
     * Creates a AllowedValue with a new object
     *
     * @param newAllowedValue the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AllowedValue> putAsync(@Nonnull final AllowedValue newAllowedValue) {
        return sendAsync(HttpMethod.PUT, newAllowedValue);
    }

    /**
     * Creates a AllowedValue with a new object
     *
     * @param newAllowedValue the object to create/update
     * @return the created AllowedValue
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AllowedValue put(@Nonnull final AllowedValue newAllowedValue) throws ClientException {
        return send(HttpMethod.PUT, newAllowedValue);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AllowedValueRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AllowedValueRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

