// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeletedItemContainer;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Deleted Item Container Request.
 */
public class DeletedItemContainerRequest extends BaseRequest<DeletedItemContainer> {
	
    /**
     * The request for the DeletedItemContainer
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeletedItemContainerRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeletedItemContainer.class);
    }

    /**
     * Gets the DeletedItemContainer from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeletedItemContainer> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeletedItemContainer from the service
     *
     * @return the DeletedItemContainer from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeletedItemContainer get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeletedItemContainer> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeletedItemContainer delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeletedItemContainer with a source
     *
     * @param sourceDeletedItemContainer the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeletedItemContainer> patchAsync(@Nonnull final DeletedItemContainer sourceDeletedItemContainer) {
        return sendAsync(HttpMethod.PATCH, sourceDeletedItemContainer);
    }

    /**
     * Patches this DeletedItemContainer with a source
     *
     * @param sourceDeletedItemContainer the source object with updates
     * @return the updated DeletedItemContainer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeletedItemContainer patch(@Nonnull final DeletedItemContainer sourceDeletedItemContainer) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeletedItemContainer);
    }

    /**
     * Creates a DeletedItemContainer with a new object
     *
     * @param newDeletedItemContainer the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeletedItemContainer> postAsync(@Nonnull final DeletedItemContainer newDeletedItemContainer) {
        return sendAsync(HttpMethod.POST, newDeletedItemContainer);
    }

    /**
     * Creates a DeletedItemContainer with a new object
     *
     * @param newDeletedItemContainer the new object to create
     * @return the created DeletedItemContainer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeletedItemContainer post(@Nonnull final DeletedItemContainer newDeletedItemContainer) throws ClientException {
        return send(HttpMethod.POST, newDeletedItemContainer);
    }

    /**
     * Creates a DeletedItemContainer with a new object
     *
     * @param newDeletedItemContainer the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeletedItemContainer> putAsync(@Nonnull final DeletedItemContainer newDeletedItemContainer) {
        return sendAsync(HttpMethod.PUT, newDeletedItemContainer);
    }

    /**
     * Creates a DeletedItemContainer with a new object
     *
     * @param newDeletedItemContainer the object to create/update
     * @return the created DeletedItemContainer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeletedItemContainer put(@Nonnull final DeletedItemContainer newDeletedItemContainer) throws ClientException {
        return send(HttpMethod.PUT, newDeletedItemContainer);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeletedItemContainerRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeletedItemContainerRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

