// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.ScheduleChangeRequestDeclineRequest;
import com.microsoft.graph.models.ScheduleChangeRequest;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.ScheduleChangeRequestDeclineParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Schedule Change Request Decline Request Builder.
 */
public class ScheduleChangeRequestDeclineRequestBuilder extends BaseActionRequestBuilder<ScheduleChangeRequest> {

    /**
     * The request builder for this ScheduleChangeRequestDecline
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ScheduleChangeRequestDeclineRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private ScheduleChangeRequestDeclineParameterSet body;
    /**
     * The request builder for this ScheduleChangeRequestDecline
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ScheduleChangeRequestDeclineRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ScheduleChangeRequestDeclineParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the ScheduleChangeRequestDeclineRequest
     *
     * @param requestOptions the options for the request
     * @return the ScheduleChangeRequestDeclineRequest instance
     */
    @Nonnull
    public ScheduleChangeRequestDeclineRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the ScheduleChangeRequestDeclineRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the ScheduleChangeRequestDeclineRequest instance
     */
    @Nonnull
    public ScheduleChangeRequestDeclineRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ScheduleChangeRequestDeclineRequest request = new ScheduleChangeRequestDeclineRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
