// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Registry Value Evidence.
 */
public class RegistryValueEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Mde Device Id.
     * A unique identifier assigned to a device by Microsoft Defender for Endpoint.
     */
    @SerializedName(value = "mdeDeviceId", alternate = {"MdeDeviceId"})
    @Expose
	@Nullable
    public String mdeDeviceId;

    /**
     * The Registry Hive.
     * Registry hive of the key that the recorded action was applied to.
     */
    @SerializedName(value = "registryHive", alternate = {"RegistryHive"})
    @Expose
	@Nullable
    public String registryHive;

    /**
     * The Registry Key.
     * Registry key that the recorded action was applied to.
     */
    @SerializedName(value = "registryKey", alternate = {"RegistryKey"})
    @Expose
	@Nullable
    public String registryKey;

    /**
     * The Registry Value.
     * Data of the registry value that the recorded action was applied to.
     */
    @SerializedName(value = "registryValue", alternate = {"RegistryValue"})
    @Expose
	@Nullable
    public String registryValue;

    /**
     * The Registry Value Name.
     * Name of the registry value that the recorded action was applied to.
     */
    @SerializedName(value = "registryValueName", alternate = {"RegistryValueName"})
    @Expose
	@Nullable
    public String registryValueName;

    /**
     * The Registry Value Type.
     * Data type, such as binary or string, of the registry value that the recorded action was applied to.
     */
    @SerializedName(value = "registryValueType", alternate = {"RegistryValueType"})
    @Expose
	@Nullable
    public String registryValueType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
