/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.PerformanceActivity;
import com.microsoft.sqlserver.jdbc.PerformanceLogCallback;
import java.util.logging.Level;
import java.util.logging.Logger;

class PerformanceLog {
    static final Logger perfLoggerConnection = Logger.getLogger("com.microsoft.sqlserver.jdbc.PerformanceMetrics.Connection");
    private static PerformanceLogCallback callback;
    private static boolean callbackInitialized;

    PerformanceLog() {
    }

    public static synchronized void registerCallback(PerformanceLogCallback cb) {
        if (callbackInitialized) {
            throw new IllegalStateException("Callback has already been set");
        }
        callback = cb;
        callbackInitialized = true;
    }

    public static synchronized void unregisterCallback() {
        callback = null;
        callbackInitialized = false;
    }

    public static Scope createScope(Logger logger, int connectionId, PerformanceActivity activity) {
        return new Scope(logger, connectionId, activity);
    }

    public static Scope createScope(Logger logger, int connectionId, Integer statementId, PerformanceActivity activity) {
        return new Scope(logger, connectionId, statementId, activity);
    }

    static {
        callbackInitialized = false;
    }

    public static class Scope
    implements AutoCloseable {
        private Logger logger;
        private int connectionId;
        private int statementId;
        private PerformanceActivity activity;
        private long startTime;
        private final boolean enabled;
        private Exception exception;

        public Scope(Logger logger, int connectionId, PerformanceActivity activity) {
            this(logger, connectionId, 0, activity);
        }

        public Scope(Logger logger, int connectionId, int statementId, PerformanceActivity activity) {
            boolean bl = this.enabled = logger.isLoggable(Level.FINE) || callback != null;
            if (this.enabled) {
                this.logger = logger;
                this.connectionId = connectionId;
                this.statementId = statementId;
                this.activity = activity;
                this.startTime = System.currentTimeMillis();
            }
        }

        public void setException(Exception e) {
            this.exception = e;
        }

        private String getTraceId() {
            if (this.statementId != 0) {
                return "ConnectionID:" + this.connectionId + ", StatementID:" + this.statementId;
            }
            return "ConnectionID:" + this.connectionId;
        }

        @Override
        public void close() {
            if (!this.enabled) {
                return;
            }
            long endTime = System.currentTimeMillis();
            long duration = endTime - this.startTime;
            if (callback != null) {
                try {
                    if (this.statementId == 0) {
                        callback.publish(this.activity, this.connectionId, duration, this.exception);
                    } else {
                        callback.publish(this.activity, this.connectionId, this.statementId, duration, this.exception);
                    }
                }
                catch (Exception e) {
                    this.logger.fine(String.format("Failed to publish performance log: %s", e.getMessage()));
                }
            }
            if (this.logger != null && this.logger.isLoggable(Level.FINE)) {
                if (this.exception != null) {
                    this.logger.fine(String.format("%s %s, duration: %dms, exception: %s", new Object[]{this.getTraceId(), this.activity, duration, this.exception.getMessage()}));
                } else {
                    this.logger.fine(String.format("%s %s, duration: %dms", new Object[]{this.getTraceId(), this.activity, duration}));
                }
            }
        }
    }
}

