/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.munit.assertion.processors.MunitAfterTest;
import org.mule.munit.assertion.processors.MunitBeforeTest;
import org.mule.munit.assertion.processors.MunitFlow;
import org.mule.munit.assertion.processors.MunitTestFlow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SuiteBuilder<T, E> {
    protected MuleContext muleContext;
    protected List<E> tests = new ArrayList();

    protected abstract T createSuite(String var1);

    protected abstract E test(List<MunitFlow> var1, MunitTestFlow var2, List<MunitFlow> var3);

    protected SuiteBuilder(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public T build(String suiteName) {
        return this.build(suiteName, null);
    }

    public T build(String suiteName, List<String> testNameList) {
        List<MunitFlow> before = this.lookupFlows(MunitBeforeTest.class);
        List<MunitFlow> after = this.lookupFlows(MunitAfterTest.class);
        Collection<MunitTestFlow> flowConstructs = this.lookupTests();
        for (MunitTestFlow flowConstruct : flowConstructs) {
            if (!this.shouldRunTest(flowConstruct, testNameList).booleanValue()) continue;
            this.tests.add(this.test(before, flowConstruct, after));
        }
        return this.createSuite(suiteName);
    }

    private Boolean shouldRunTest(MunitTestFlow munitTestFlow, List<String> testNameList) {
        if (null == testNameList || testNameList.isEmpty()) {
            return true;
        }
        for (String testToRunName : testNameList) {
            if (!StringUtils.isNotBlank((String)testToRunName) || !munitTestFlow.getName().matches(testToRunName)) continue;
            return true;
        }
        return false;
    }

    private List<MunitFlow> lookupFlows(Class munitClass) {
        return new ArrayList<MunitFlow>(this.muleContext.getRegistry().lookupObjects(munitClass));
    }

    private Collection<MunitTestFlow> lookupTests() {
        return new ArrayList<MunitTestFlow>(this.muleContext.getRegistry().lookupObjects(MunitTestFlow.class));
    }
}

