/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.mule;

import java.util.ArrayList;
import java.util.List;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;
import org.mule.munit.runner.mule.result.notification.DummyNotificationListener;
import org.mule.munit.runner.mule.result.notification.NotificationListener;

public class MunitSuite {
    private String name;
    private List<MunitTest> munitTests = new ArrayList<MunitTest>();
    private NotificationListener notificationListener = new DummyNotificationListener();

    public MunitSuite(String name) {
        this.name = name;
    }

    public void add(MunitTest test) {
        this.munitTests.add(test);
    }

    public SuiteResult run() throws Exception {
        SuiteResult result = new SuiteResult(this.name);
        for (MunitTest test : this.munitTests) {
            this.notificationListener.notifyStartOf(test);
            TestResult testResult = test.run();
            result.add(testResult);
            if (testResult.isSkipped()) {
                this.notificationListener.notifyIgnored(testResult);
            }
            this.notificationListener.notify(testResult);
        }
        this.notificationListener.notifyEnd(result);
        return result;
    }

    public void setNotificationListener(NotificationListener notificationListener) {
        if (notificationListener == null) {
            throw new IllegalArgumentException();
        }
        this.notificationListener = notificationListener;
    }

    public int getNumberOfTests() {
        return this.munitTests.size();
    }

    public String getName() {
        return this.name;
    }
}

