/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Joiner;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.base.OpenEHRBase;
import java.util.ArrayList;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="CARDINALITY", propOrder={"isOrdered", "isUnique", "interval"})
public class Cardinality
extends OpenEHRBase {
    private MultiplicityInterval interval;
    @XmlElement(name="is_ordered")
    private boolean isOrdered = true;
    @XmlElement(name="is_unique")
    private boolean isUnique = false;

    public Cardinality() {
    }

    public Cardinality(int lower, int higher) {
        this.isOrdered = true;
        this.isUnique = false;
        this.interval = new MultiplicityInterval(lower, higher);
    }

    public MultiplicityInterval getInterval() {
        return this.interval;
    }

    public void setInterval(MultiplicityInterval interval) {
        this.interval = interval;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public void setOrdered(boolean ordered) {
        this.isOrdered = ordered;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean unique) {
        this.isUnique = unique;
    }

    public static Cardinality unbounded() {
        Cardinality result = new Cardinality();
        result.setInterval(MultiplicityInterval.unbounded());
        return result;
    }

    public static Cardinality mandatoryAndUnbounded() {
        Cardinality result = new Cardinality();
        result.setInterval(new MultiplicityInterval(1, true, false, null, true, true));
        return result;
    }

    @JsonIgnore
    public Boolean isBag() {
        return !this.isOrdered && !this.isUnique;
    }

    @JsonIgnore
    public Boolean isList() {
        return this.isOrdered && !this.isUnique;
    }

    @JsonIgnore
    public Boolean isSet() {
        return !this.isOrdered && this.isUnique;
    }

    public Boolean contains(Cardinality other) {
        return this.getInterval().contains(other.getInterval());
    }

    public boolean equals(Object other) {
        if (other instanceof Cardinality) {
            Cardinality otherCardinality = (Cardinality)other;
            return this.isOrdered == otherCardinality.isOrdered && this.isUnique == otherCardinality.isUnique && Objects.equals(this.interval, otherCardinality.interval);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.isOrdered, this.isUnique);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("cardinality matches {");
        builder.append(this.interval.toString());
        builder.append("}");
        ArrayList<String> tags = new ArrayList<String>();
        if (!this.isOrdered()) {
            tags.add("unordered");
        }
        if (this.isUnique()) {
            tags.add("isUnique");
        }
        if (!tags.isEmpty()) {
            builder.append("; ").append(Joiner.on((String)"; ").join(tags));
        }
        return builder.toString();
    }
}

