/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.base.IntervalDurationConverter;
import com.nedap.archie.base.OpenEHRBase;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rminfo.RMPropertyIgnore;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="INTERVAL")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Interval<T>
extends OpenEHRBase {
    @Nullable
    private T lower;
    @Nullable
    private T upper;
    @XmlAttribute(name="lower_unbounded")
    private boolean lowerUnbounded = false;
    @XmlAttribute(name="upper_unbounded")
    private boolean upperUnbounded = false;
    @XmlAttribute(name="lower_included")
    private boolean lowerIncluded = true;
    @XmlAttribute(name="upper_included")
    private boolean upperIncluded = true;

    public Interval() {
    }

    public Interval(T value) {
        this(value, value);
    }

    public Interval(T lower, T upper) {
        this(lower, upper, true, true);
    }

    public Interval(T lower, T upper, boolean lowerIncluded, boolean upperIncluded) {
        this.lower = lower;
        this.upper = upper;
        this.lowerIncluded = lowerIncluded;
        this.upperIncluded = upperIncluded;
        if (upper == null) {
            this.upperUnbounded = true;
            this.upperIncluded = false;
        }
        if (lower == null) {
            this.lowerUnbounded = true;
            this.lowerIncluded = false;
        }
    }

    public static <T> Interval<T> lowerUnbounded(T upper, boolean upperIncluded) {
        Interval<Object> result = new Interval<Object>(null, upper, false, upperIncluded);
        result.setLowerUnbounded(true);
        return result;
    }

    public static <T> Interval<T> upperUnbounded(T lower, boolean lowerIncluded) {
        Interval<Object> result = new Interval<Object>(lower, null, lowerIncluded, false);
        result.setUpperUnbounded(true);
        return result;
    }

    public static <T> Interval<T> unbounded() {
        Interval<Object> result = new Interval<Object>(null, null, false, false);
        result.setLowerUnbounded(true);
        result.setUpperUnbounded(true);
        return result;
    }

    public T getLower() {
        return this.lower;
    }

    public void setLower(T lower) {
        this.lower = lower;
    }

    public T getUpper() {
        return this.upper;
    }

    public void setUpper(T upper) {
        this.upper = upper;
    }

    public boolean isLowerUnbounded() {
        return this.lowerUnbounded;
    }

    public void setLowerUnbounded(boolean lowerUnbounded) {
        this.lowerUnbounded = lowerUnbounded;
    }

    public boolean isUpperUnbounded() {
        return this.upperUnbounded;
    }

    public void setUpperUnbounded(boolean upperUnbounded) {
        this.upperUnbounded = upperUnbounded;
    }

    public boolean isLowerIncluded() {
        return this.lowerIncluded;
    }

    public void setLowerIncluded(boolean lowerIncluded) {
        this.lowerIncluded = lowerIncluded;
    }

    public boolean isUpperIncluded() {
        return this.upperIncluded;
    }

    public void setUpperIncluded(boolean upperIncluded) {
        this.upperIncluded = upperIncluded;
    }

    public boolean has(T value) {
        int comparedWithUpper;
        int comparedWithLower;
        Comparable comparableUpper;
        Comparable comparableLower;
        Comparable comparableValue;
        if (this.lowerUnbounded && this.upperUnbounded) {
            return true;
        }
        if (value instanceof TemporalAmount && this.lower instanceof TemporalAmount && this.upper instanceof TemporalAmount) {
            comparableValue = this.toComparable(value);
            comparableLower = this.toComparable(this.lower);
            comparableUpper = this.toComparable(this.upper);
        } else {
            if (!(this.isComparable(this.lower) && this.isComparable(this.upper) && this.isComparable(value))) {
                throw new UnsupportedOperationException("subclasses of interval not implementing comparable should implement their own has method");
            }
            comparableValue = (Comparable)value;
            comparableLower = (Comparable)this.lower;
            comparableUpper = (Comparable)this.upper;
        }
        if (value == null) {
            return true;
        }
        if (!this.lowerUnbounded && ((comparedWithLower = comparableValue.compareTo(comparableLower)) < 0 || !this.lowerIncluded && comparedWithLower == 0)) {
            return false;
        }
        return this.upperUnbounded || (comparedWithUpper = comparableValue.compareTo(comparableUpper)) <= 0 && (this.upperIncluded || comparedWithUpper != 0);
    }

    @JsonIgnore
    @XmlTransient
    @RMPropertyIgnore
    public Comparable getComparableLower() {
        return this.toComparable(this.lower);
    }

    @JsonIgnore
    @XmlTransient
    @RMPropertyIgnore
    public Comparable getComparableUpper() {
        return this.toComparable(this.upper);
    }

    private Comparable toComparable(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof TemporalAmount && !(value instanceof Comparable) && this.isNonComparableTemporalAmount(value)) {
            return IntervalDurationConverter.from((TemporalAmount)value);
        }
        if (!this.isComparable(value)) {
            throw new UnsupportedOperationException("subclasses of interval not implementing comparable should implement their own has method");
        }
        return (Comparable)value;
    }

    private int compareTo(T intervalValue, T value) {
        Comparable comparableIntervalValue;
        Comparable comparableValue;
        if (value instanceof TemporalAmount && !(value instanceof Comparable) && this.isNonComparableTemporalAmount(intervalValue)) {
            comparableValue = value == null ? null : IntervalDurationConverter.from((TemporalAmount)value);
            comparableIntervalValue = intervalValue == null ? null : IntervalDurationConverter.from((TemporalAmount)intervalValue);
        } else {
            if (!this.isComparable(intervalValue) || !this.isComparable(value)) {
                throw new UnsupportedOperationException("subclasses of interval not implementing comparable should implement their own has method");
            }
            comparableValue = (Comparable)value;
            comparableIntervalValue = (Comparable)intervalValue;
        }
        return comparableValue.compareTo(comparableIntervalValue);
    }

    private boolean isNonComparableTemporalAmount(T value) {
        return value == null || !(value instanceof Comparable) && value instanceof TemporalAmount;
    }

    private boolean isComparable(T value) {
        return value == null || value instanceof Comparable;
    }

    public Boolean intersects(Interval<T> other) {
        return this.lowerUnbounded && other.lowerUnbounded || this.upperUnbounded && other.upperUnbounded || this.compareTo(this.lower, other.lower) < 0 && this.compareTo(this.upper, other.upper) < 0 && this.compareTo(other.lower, this.upper) < 0 || this.compareTo(other.lower, this.lower) < 0 && this.compareTo(other.upper, this.upper) < 0 && this.compareTo(this.lower, other.upper) < 0 || other.contains(this) != false || this.contains(other) != false;
    }

    public Boolean contains(Interval<T> other) {
        boolean otherHasLower = false;
        boolean otherHasUpper = false;
        otherHasLower = other.lowerUnbounded ? this.lowerUnbounded : this.has(other.lower);
        otherHasUpper = other.upperUnbounded ? this.upperUnbounded : this.has(other.upper);
        return otherHasLower && otherHasUpper;
    }

    public Boolean setsAreEqual(Interval<T> other) {
        return this.contains(other) != false && other.contains(this) != false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        return !(this.lowerUnbounded != interval.lowerUnbounded || this.upperUnbounded != interval.upperUnbounded || !this.lowerUnbounded && this.lowerIncluded != interval.lowerIncluded || !this.upperUnbounded && this.upperIncluded != interval.upperIncluded || !this.lowerUnbounded && !Objects.equals(this.lower, interval.lower) || !this.upperUnbounded && !Objects.equals(this.upper, interval.upper));
    }

    public int hashCode() {
        return Objects.hash(this.lowerUnbounded, this.upperUnbounded, this.lowerUnbounded ? false : this.lowerIncluded, this.upperUnbounded ? false : this.upperIncluded, this.lowerUnbounded ? null : this.lower, this.upperUnbounded ? null : this.upper);
    }

    public String toString() {
        if (this.lowerUnbounded) {
            return "|" + (this.upperIncluded ? "<=" : "<") + this.upper + "|";
        }
        if (this.upperUnbounded) {
            return "|" + (this.lowerIncluded ? ">=" : ">") + this.lower + "|";
        }
        if (this.lower != null && this.upper != null && this.lower == this.upper) {
            return this.lower.toString();
        }
        StringBuilder result = new StringBuilder();
        result.append("|");
        if (!this.lowerIncluded) {
            result.append(">");
        }
        result.append(this.lower);
        result.append("..");
        if (!this.upperIncluded) {
            result.append("<");
        }
        result.append(this.upper);
        result.append("|");
        return result.toString();
    }

    public void fixUnboundedIncluded() {
        if (this.upperUnbounded) {
            this.upperIncluded = false;
        }
        if (this.lowerUnbounded) {
            this.lowerIncluded = false;
        }
    }

    @Invariant(value="Lower_included_valid")
    public boolean lowerIncludedValid() {
        if (this.lowerUnbounded) {
            return !this.lowerIncluded;
        }
        return true;
    }

    @Invariant(value="Upper_included_valid")
    public boolean upperIncludedValid() {
        if (this.upperUnbounded) {
            return !this.upperIncluded;
        }
        return true;
    }

    @Invariant(value="Limits_consistent")
    public boolean limitsConsistent() {
        if (!this.lowerUnbounded && !this.upperUnbounded) {
            return this.compareTo(this.upper, this.lower) <= 0;
        }
        return true;
    }

    @Invariant(value="Limits_comparable", ignored=true)
    public boolean limitsComparable() {
        return true;
    }
}

