/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.base;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.base.Interval;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MultiplicityInterval
extends Interval<Integer>
implements Serializable {
    public static final String MULTIPLICITY_RANGE_MARKER = "..";
    public static final Character MULTIPLICITY_UNBOUNDED_MARKER = Character.valueOf('*');

    public MultiplicityInterval() {
    }

    public MultiplicityInterval(int lower, int upper) {
        super(lower, upper);
    }

    public MultiplicityInterval(Interval<Integer> interval) {
        this(interval.getLower(), interval.isLowerIncluded(), interval.isLowerUnbounded(), interval.getUpper(), interval.isUpperIncluded(), interval.isUpperUnbounded());
    }

    public MultiplicityInterval(Integer lower, Boolean lowerIncluded, Boolean lowerUnbounded, Integer upper, Boolean upperIncluded, Boolean upperUnbounded) {
        this.setLower(lower);
        this.setLowerIncluded(lowerIncluded);
        this.setLowerUnbounded(lowerUnbounded);
        this.setUpper(upper);
        this.setUpperIncluded(upperIncluded);
        this.setUpperUnbounded(upperUnbounded);
    }

    @JsonCreator
    public static MultiplicityInterval createFromString(String interval) {
        Pattern pattern = Pattern.compile("(?<lower>[0-9]+)\\.\\.(?<upper>[0-9]+|\\*)");
        Matcher matcher = pattern.matcher(interval);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Cannot parse interval " + interval);
        }
        String lower = matcher.group("lower");
        String upper = matcher.group("upper");
        MultiplicityInterval result = new MultiplicityInterval();
        if (upper.equalsIgnoreCase("*")) {
            result.setUpperUnbounded(true);
        } else {
            result.setUpper(Integer.parseInt(upper));
        }
        result.setLower(Integer.parseInt(lower));
        return result;
    }

    public static MultiplicityInterval unbounded() {
        MultiplicityInterval result = new MultiplicityInterval();
        result.setLower(0);
        result.setUpperUnbounded(true);
        return result;
    }

    public boolean isOpen() {
        return Integer.valueOf(0).equals(this.getLower()) && this.isUpperUnbounded() && this.isLowerIncluded();
    }

    public boolean isOptional() {
        return Integer.valueOf(0).equals(this.getLower()) && Integer.valueOf(1).equals(this.getUpper()) && !this.isUpperUnbounded() && this.isLowerIncluded() && this.isUpperIncluded();
    }

    public boolean isMandatory() {
        return !this.isLowerUnbounded() && (Integer)this.getLower() >= 1;
    }

    public boolean isProhibited() {
        return Integer.valueOf(0).equals(this.getLower()) && Integer.valueOf(0).equals(this.getUpper()) && !this.isUpperUnbounded();
    }

    public static MultiplicityInterval createOpen() {
        return new MultiplicityInterval(0, true, false, null, true, true);
    }

    public static MultiplicityInterval createOptional() {
        return new MultiplicityInterval(0, true, false, 1, true, false);
    }

    public static MultiplicityInterval createMandatory() {
        return new MultiplicityInterval(1, true, false, 1, true, false);
    }

    public static MultiplicityInterval createProhibited() {
        return new MultiplicityInterval(0, true, false, 0, true, false);
    }

    public static MultiplicityInterval createUpperUnbounded(Integer lower) {
        return new MultiplicityInterval(lower, true, false, null, true, true);
    }

    public static MultiplicityInterval createBounded(int lower, int upper) {
        return new MultiplicityInterval(lower, true, false, upper, true, false);
    }

    @JsonIgnore
    public boolean upperIsOne() {
        return this.has(1) && !this.has(2);
    }

    @Override
    public String toString() {
        Integer lower = (Integer)this.getLower();
        Integer upper = (Integer)this.getUpper();
        StringBuilder result = new StringBuilder();
        if (this.isLowerUnbounded()) {
            result.append(MULTIPLICITY_UNBOUNDED_MARKER);
        } else {
            if (!this.isLowerIncluded()) {
                result.append(">");
            }
            result.append(lower);
        }
        result.append(MULTIPLICITY_RANGE_MARKER);
        if (this.isUpperUnbounded()) {
            result.append(MULTIPLICITY_UNBOUNDED_MARKER);
        } else {
            if (!this.isUpperIncluded()) {
                result.append("<");
            }
            result.append(upper);
        }
        return result.toString();
    }
}

