/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.atlas.AtlasMeter;
import com.netflix.spectator.atlas.DsType;
import com.netflix.spectator.atlas.MeasurementConsumer;
import com.netflix.spectator.impl.StepDouble;
import com.netflix.spectator.impl.StepLong;
import com.netflix.spectator.impl.StepValue;
import java.util.concurrent.atomic.AtomicLong;

class AtlasDistributionSummary
extends AtlasMeter
implements DistributionSummary {
    private final StepLong count;
    private final StepLong total;
    private final StepDouble totalOfSquares;
    private final StepLong max;
    private final Id[] stats;

    AtlasDistributionSummary(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.count = new StepLong(0L, clock, step);
        this.total = new StepLong(0L, clock, step);
        this.totalOfSquares = new StepDouble(0.0, clock, step);
        this.max = new StepLong(0L, clock, step);
        this.stats = new Id[]{id.withTags(new Tag[]{DsType.rate, Statistic.count}), id.withTags(new Tag[]{DsType.rate, Statistic.totalAmount}), id.withTags(new Tag[]{DsType.rate, Statistic.totalOfSquares}), id.withTags(new Tag[]{DsType.gauge, Statistic.max})};
    }

    @Override
    void measure(MeasurementConsumer consumer) {
        this.reportMeasurement(consumer, this.stats[0], (StepValue)this.count);
        this.reportMeasurement(consumer, this.stats[1], (StepValue)this.total);
        this.reportMeasurement(consumer, this.stats[2], (StepValue)this.totalOfSquares);
        this.reportMaxMeasurement(consumer, this.stats[3], this.max);
    }

    private void reportMeasurement(MeasurementConsumer consumer, Id mid, StepValue v) {
        double rate = v.pollAsRate();
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, rate);
    }

    private void reportMaxMeasurement(MeasurementConsumer consumer, Id mid, StepLong v) {
        double maxValue = v.poll();
        long timestamp = v.timestamp();
        consumer.accept(mid, timestamp, maxValue);
    }

    public void record(long amount) {
        this.count.getCurrent().incrementAndGet();
        if (amount > 0L) {
            this.total.getCurrent().addAndGet(amount);
            this.totalOfSquares.getCurrent().addAndGet((double)amount * (double)amount);
            this.updateMax(this.max.getCurrent(), amount);
        }
        this.updateLastModTime();
    }

    private void updateMax(AtomicLong maxValue, long v) {
        long p = maxValue.get();
        while (v > p && !maxValue.compareAndSet(p, v)) {
            p = maxValue.get();
        }
    }

    public long count() {
        return this.count.poll();
    }

    public long totalAmount() {
        return this.total.poll();
    }
}

