/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.deser.std;

import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.BeanDescription;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.DeserializationConfig;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.JavaType;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.JsonDeserializer;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.JsonMappingException;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.KeyDeserializer;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.MapperFeature;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.deser.KeyDeserializers;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.deser.std.StdKeyDeserializer;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.introspect.AnnotatedMethod;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.util.ClassUtil;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 1L;

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver) {
        return new StdKeyDeserializer.EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod factory) {
        return new StdKeyDeserializer.EnumKD(enumResolver, factory);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig config, JavaType type, JsonDeserializer<?> deser) {
        return new StdKeyDeserializer.DelegatingKD(type.getRawClass(), deser);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig config, JavaType type) {
        Object beanDesc = config.introspect(type);
        Constructor<?> ctor = ((BeanDescription)beanDesc).findSingleArgConstructor(String.class);
        if (ctor != null) {
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(ctor, config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringCtorKeyDeserializer(ctor);
        }
        Method m = ((BeanDescription)beanDesc).findFactoryMethod(String.class);
        if (m != null) {
            if (config.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(m, config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer.StringFactoryKeyDeserializer(m);
        }
        return null;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> raw = type.getRawClass();
        if (raw.isPrimitive()) {
            raw = ClassUtil.wrapperType(raw);
        }
        return StdKeyDeserializer.forType(raw);
    }
}

