/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.serialization.JsonMapperFactory;
import com.networknt.schema.utils.JsonType;
import com.networknt.schema.utils.TypeFactory;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Pattern;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.JsonNode;

public class ContentMediaTypeValidator
extends BaseKeywordValidator {
    private static final String PATTERN_STRING = "(application|audio|font|example|image|message|model|multipart|text|video|x-(?:[0-9A-Za-z!#$%&'*+.^_`|~-]+))/([0-9A-Za-z!#$%&'*+.^_`|~-]+)((?:[ \t]*;[ \t]*[0-9A-Za-z!#$%&'*+.^_`|~-]+=(?:[0-9A-Za-z!#$%&'*+.^_`|~-]+|\"(?:[^\"\\\\]|\\.)*\"))*)";
    private static final Pattern PATTERN = Pattern.compile("(application|audio|font|example|image|message|model|multipart|text|video|x-(?:[0-9A-Za-z!#$%&'*+.^_`|~-]+))/([0-9A-Za-z!#$%&'*+.^_`|~-]+)((?:[ \t]*;[ \t]*[0-9A-Za-z!#$%&'*+.^_`|~-]+=(?:[0-9A-Za-z!#$%&'*+.^_`|~-]+|\"(?:[^\"\\\\]|\\.)*\"))*)");
    private final String contentMediaType;

    public ContentMediaTypeValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.CONTENT_MEDIA_TYPE, schemaNode, schemaLocation, parentSchema, schemaContext);
        this.contentMediaType = schemaNode.asString();
    }

    private boolean matches(String value) {
        if ("application/json".equals(this.contentMediaType)) {
            JsonNode node = this.parentSchema.getSchemaNode().get("contentEncoding");
            String encoding = null;
            if (node != null && node.isString()) {
                encoding = node.asString();
            }
            String data = value;
            if ("base64".equals(encoding)) {
                try {
                    data = new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
                }
                catch (IllegalArgumentException e) {
                    return true;
                }
            }
            try {
                JsonMapperFactory.getInstance().readTree(data);
            }
            catch (JacksonException e) {
                return false;
            }
            return true;
        }
        return PATTERN.matcher(this.contentMediaType).matches();
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.schemaContext.getSchemaRegistryConfig());
        if (nodeType != JsonType.STRING) {
            return;
        }
        if (this.collectAnnotations(executionContext)) {
            this.putAnnotation(executionContext, annotation -> annotation.instanceLocation(instanceLocation).value(this.contentMediaType));
        }
        if (!this.matches(node.asString())) {
            executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(this.contentMediaType)).build());
        }
    }
}

