/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.path.NodePath;
import java.util.ArrayList;
import java.util.List;
import tools.jackson.databind.JsonNode;

public class NotValidator
extends BaseKeywordValidator {
    private final Schema schema;

    public NotValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.NOT, schemaNode, schemaLocation, parentSchema, schemaContext);
        this.schema = schemaContext.newSchema(schemaLocation, schemaNode, parentSchema);
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean walk) {
        boolean failFast = executionContext.isFailFast();
        List<Error> existingErrors = executionContext.getErrors();
        ArrayList<Error> test = new ArrayList<Error>();
        executionContext.setErrors(test);
        try {
            executionContext.setFailFast(false);
            if (!walk) {
                this.schema.validate(executionContext, node, rootNode, instanceLocation);
            } else {
                this.schema.walk(executionContext, node, rootNode, instanceLocation, true);
            }
        }
        finally {
            executionContext.setFailFast(failFast);
            executionContext.setErrors(existingErrors);
        }
        if (test.isEmpty()) {
            executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(this.schemaNode.toString())).build());
        }
    }

    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema && node != null) {
            this.validate(executionContext, node, rootNode, instanceLocation, true);
            return;
        }
        this.schema.walk(executionContext, node, rootNode, instanceLocation, false);
    }

    @Override
    public void preloadSchema() {
        if (null != this.schema) {
            this.schema.initializeValidators();
        }
    }
}

