/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import com.networknt.schema.path.NodePath;
import com.networknt.schema.serialization.node.JsonNodeFactoryFactory;
import com.networknt.schema.serialization.node.TokenStreamLocationAware;
import java.io.InputStream;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.node.JsonNodeFactory;

public class JsonNodes {
    public static <T extends JsonNode> T get(JsonNode node, NodePath path) {
        int nameCount = path.getNameCount();
        Object current = node;
        for (int x = 0; x < nameCount; ++x) {
            Object segment = path.getElement(x);
            T result = JsonNodes.get(current, segment);
            if (result == null) {
                return null;
            }
            current = result;
        }
        return (T)current;
    }

    public static <T extends JsonNode> T get(JsonNode node, Object propertyOrIndex) {
        JsonNode value = null;
        value = propertyOrIndex instanceof Number && node.isArray() ? node.get(((Number)propertyOrIndex).intValue()) : node.get(propertyOrIndex.toString());
        return (T)value;
    }

    public static JsonNode readTree(ObjectMapper objectMapper, String content, JsonNodeFactoryFactory jsonNodeFactoryFactory) {
        JsonNode jsonNode;
        block8: {
            JsonParser parser = objectMapper.createParser(content);
            try {
                JsonNodeFactory nodeFactory = jsonNodeFactoryFactory.getJsonNodeFactory(parser);
                ObjectReader reader = objectMapper.reader(nodeFactory);
                JsonNode result = reader.readTree(parser);
                JsonNode jsonNode2 = jsonNode = result != null ? result : nodeFactory.missingNode();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JacksonException e) {
                    throw new IllegalArgumentException("Invalid input", e);
                }
            }
            parser.close();
        }
        return jsonNode;
    }

    public static JsonNode readTree(ObjectMapper objectMapper, InputStream inputStream, JsonNodeFactoryFactory jsonNodeFactoryFactory) {
        JsonNode jsonNode;
        block8: {
            JsonParser parser = objectMapper.createParser(inputStream);
            try {
                JsonNodeFactory nodeFactory = jsonNodeFactoryFactory.getJsonNodeFactory(parser);
                ObjectReader reader = objectMapper.reader(nodeFactory);
                JsonNode result = reader.readTree(parser);
                JsonNode jsonNode2 = jsonNode = result != null ? result : nodeFactory.missingNode();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JacksonException e) {
                    throw new IllegalArgumentException("Invalid input", e);
                }
            }
            parser.close();
        }
        return jsonNode;
    }

    public static TokenStreamLocation tokenStreamLocationOf(JsonNode jsonNode) {
        if (jsonNode instanceof TokenStreamLocationAware) {
            return ((TokenStreamLocationAware)jsonNode).tokenStreamLocation();
        }
        throw new IllegalArgumentException("JsonNode does not contain the location information.");
    }
}

