/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.servlet;

import com.noelios.restlet.local.WarClientHelper;
import java.io.InputStream;
import java.util.Set;
import javax.servlet.ServletContext;
import org.restlet.Client;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.Variant;
import org.restlet.service.MetadataService;

public class ServletWarClientHelper
extends WarClientHelper {
    private ServletContext servletContext;

    public ServletWarClientHelper(Client client, ServletContext servletContext) {
        super(client);
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected void handleWar(Request request, Response response) {
        if (request.getMethod().equals((Object)Method.GET) || request.getMethod().equals((Object)Method.HEAD)) {
            String basePath = request.getResourceRef().getPath();
            int lastSlashIndex = basePath.lastIndexOf(47);
            String entry2 = lastSlashIndex == -1 ? basePath : basePath.substring(lastSlashIndex + 1);
            InputRepresentation output = null;
            if (basePath.endsWith("/")) {
                Set entries = this.getServletContext().getResourcePaths(basePath);
                if (entries != null) {
                    ReferenceList rl = new ReferenceList(entries.size());
                    rl.setIdentifier(request.getResourceRef());
                    for (String entry2 : entries) {
                        rl.add((Object)new Reference(basePath + entry2.substring(basePath.length())));
                    }
                    output = rl.getTextRepresentation();
                }
            } else {
                MetadataService metadataService = this.getMetadataService(request);
                InputStream ris = this.getServletContext().getResourceAsStream(basePath);
                if (ris != null) {
                    output = new InputRepresentation(ris, metadataService.getDefaultMediaType());
                    output.setIdentifier(request.getResourceRef());
                    this.updateMetadata(metadataService, entry2, (Variant)output);
                    String mediaType = this.getServletContext().getMimeType(basePath);
                    if (mediaType != null) {
                        output.setMediaType(new MediaType(mediaType));
                    }
                }
            }
            response.setEntity(output);
            response.setStatus(Status.SUCCESS_OK);
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.GET);
            response.getAllowedMethods().add(Method.HEAD);
        }
    }
}

