/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.component;

import com.noelios.restlet.ChainHelper;
import com.noelios.restlet.StatusFilter;
import com.noelios.restlet.component.ClientRouter;
import com.noelios.restlet.component.ComponentContext;
import com.noelios.restlet.component.ComponentStatusFilter;
import com.noelios.restlet.component.ServerRouter;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.Server;
import org.restlet.VirtualHost;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class ComponentHelper
extends ChainHelper {
    private Component component;
    private ClientRouter clientRouter;
    private ServerRouter serverRouter;

    public ComponentHelper(Component component) {
        super(null);
        this.component = component;
        this.clientRouter = new ClientRouter(this.getComponent());
        this.serverRouter = new ServerRouter(this.getComponent());
    }

    public Context createContext(String loggerName) {
        return new ComponentContext(this, Logger.getLogger(loggerName));
    }

    public ClientRouter getClientRouter() {
        return this.clientRouter;
    }

    protected Component getComponent() {
        return this.component;
    }

    public ServerRouter getServerRouter() {
        return this.serverRouter;
    }

    public void handle(Request request, Response response) {
        if (this.getFirst() != null) {
            this.getFirst().handle(request, response);
        } else {
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
            this.getComponent().getLogger().log(Level.SEVERE, "The component wasn't properly started, it can't handle calls.");
        }
    }

    public void start() throws Exception {
        Filter lastFilter = null;
        boolean success = this.checkVirtualHost(this.getComponent().getDefaultHost());
        if (success) {
            for (VirtualHost host : this.getComponent().getHosts()) {
                success = success && this.checkVirtualHost(host);
            }
        }
        if (!success) {
            this.getComponent().stop();
        } else {
            if (this.getComponent().getLogService().isEnabled()) {
                lastFilter = this.createLogFilter(this.getComponent().getContext(), this.getComponent().getLogService());
                this.setFirst((Restlet)lastFilter);
            }
            if (this.getComponent().getStatusService().isEnabled()) {
                StatusFilter statusFilter = this.createStatusFilter(this.getComponent());
                if (lastFilter != null) {
                    lastFilter.setNext((Restlet)statusFilter);
                }
                if (this.getFirst() == null) {
                    this.setFirst((Restlet)statusFilter);
                }
                lastFilter = statusFilter;
            }
            if (this.getFirst() == null) {
                this.setFirst((Restlet)this.getServerRouter());
            } else {
                lastFilter.setNext((Restlet)this.getServerRouter());
            }
        }
    }

    private boolean checkVirtualHost(VirtualHost host) throws Exception {
        boolean result = true;
        if (host != null) {
            for (Route route : host.getRoutes()) {
                Iterator iter;
                Restlet next = route.getNext();
                if (!(next instanceof Application)) continue;
                Application application = (Application)next;
                for (Protocol clientProtocol : application.getConnectorService().getClientProtocols()) {
                    boolean clientFound = false;
                    iter = this.getComponent().getClients().iterator();
                    while (!clientFound && iter.hasNext()) {
                        Client client = (Client)iter.next();
                        clientFound = client.getProtocols().contains(clientProtocol);
                    }
                    if (clientFound) continue;
                    this.getComponent().getLogger().severe("Unable to start the application \"" + application.getName() + "\". Client connector for protocol " + clientProtocol.getName() + " is missing.");
                    result = false;
                }
                for (Protocol serverProtocol : application.getConnectorService().getServerProtocols()) {
                    boolean serverFound = false;
                    iter = this.getComponent().getServers().iterator();
                    while (!serverFound && iter.hasNext()) {
                        Server server = (Server)iter.next();
                        serverFound = server.getProtocols().contains(serverProtocol);
                    }
                    if (serverFound) continue;
                    this.getComponent().getLogger().severe("Unable to start the application \"" + application.getName() + "\". Server connector for protocol " + serverProtocol.getName() + " is missing.");
                    result = false;
                }
                if (!result || !application.isStopped()) continue;
                application.start();
            }
        }
        return result;
    }

    protected StatusFilter createStatusFilter(Component component) {
        return new ComponentStatusFilter(component);
    }

    public void stop() throws Exception {
        this.stopVirtualHostApplications(this.getComponent().getDefaultHost());
        for (VirtualHost host : this.getComponent().getHosts()) {
            this.stopVirtualHostApplications(host);
        }
    }

    private void stopVirtualHostApplications(VirtualHost host) throws Exception {
        for (Route route : host.getRoutes()) {
            Application application;
            Restlet next = route.getNext();
            if (!(next instanceof Application) || !(application = (Application)next).isStarted()) continue;
            application.stop();
        }
    }
}

