/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import com.noelios.restlet.http.HttpConverter;
import com.noelios.restlet.http.HttpRequest;
import com.noelios.restlet.http.HttpResponse;
import com.noelios.restlet.http.HttpServerCall;
import com.noelios.restlet.util.CookieUtils;
import com.noelios.restlet.util.SecurityUtils;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.util.DateUtils;
import org.restlet.util.Series;

public class HttpServerConverter
extends HttpConverter {
    public HttpServerConverter(Context context) {
        super(context);
    }

    public HttpRequest toRequest(HttpServerCall httpCall) {
        HttpRequest result = new HttpRequest(this.getContext(), httpCall);
        result.getAttributes().put("org.restlet.http.headers", httpCall.getRequestHeaders());
        if (httpCall.getVersion() != null) {
            result.getAttributes().put("org.restlet.http.version", httpCall.getVersion());
        }
        return result;
    }

    public void commit(HttpResponse response) {
        try {
            this.addResponseHeaders(response);
            response.getHttpCall().sendResponse(response);
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "Exception intercepted", e);
            response.getHttpCall().setStatusCode(Status.SERVER_ERROR_INTERNAL.getCode());
            response.getHttpCall().setReasonPhrase("An unexpected exception occured");
        }
    }

    protected void addResponseHeaders(HttpResponse response) {
        try {
            Set dimensions;
            Series<Parameter> responseHeaders = response.getHttpCall().getResponseHeaders();
            if (response.getStatus().equals((Object)Status.CLIENT_ERROR_METHOD_NOT_ALLOWED)) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Method method : response.getAllowedMethods()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(method.getName());
                }
                responseHeaders.add("Allow", sb.toString());
            }
            responseHeaders.add("Date", DateUtils.format((Date)new Date(), (String)((String)DateUtils.FORMAT_RFC_1123.get(0))));
            Series cookies = response.getCookieSettings();
            for (int i = 0; i < cookies.size(); ++i) {
                responseHeaders.add("Set-Cookie", CookieUtils.format((CookieSetting)cookies.get(i)));
            }
            if (response.getRedirectRef() != null) {
                responseHeaders.add("Location", response.getRedirectRef().toString());
            }
            if (response.getChallengeRequest() != null) {
                responseHeaders.add("WWW-Authenticate", SecurityUtils.format(response.getChallengeRequest()));
            }
            response.getHttpCall().getResponseHeaders().add("Server", response.getServerInfo().getAgent());
            if (response.getStatus() != null) {
                response.getHttpCall().setStatusCode(response.getStatus().getCode());
                response.getHttpCall().setReasonPhrase(response.getStatus().getDescription());
            }
            if (response.getEntity() != null) {
                StringBuilder value;
                Representation entity = response.getEntity();
                if (entity.getExpirationDate() != null) {
                    responseHeaders.add("Expires", response.getHttpCall().formatDate(entity.getExpirationDate(), false));
                }
                if (!entity.getEncodings().isEmpty()) {
                    value = new StringBuilder();
                    for (Encoding encoding : entity.getEncodings()) {
                        if (!encoding.equals((Object)Encoding.IDENTITY)) {
                            if (value.length() > 0) {
                                value.append(", ");
                            }
                            value.append(encoding.getName());
                        }
                        responseHeaders.add("Content-Encoding", value.toString());
                    }
                }
                if (!entity.getLanguages().isEmpty()) {
                    value = new StringBuilder();
                    for (int i = 0; i < entity.getLanguages().size(); ++i) {
                        if (i > 0) {
                            value.append(", ");
                        }
                        value.append(((Language)entity.getLanguages().get(i)).getName());
                    }
                    responseHeaders.add("Content-Language", value.toString());
                }
                if (entity.getMediaType() != null) {
                    StringBuilder contentType = new StringBuilder(entity.getMediaType().getName());
                    if (entity.getCharacterSet() != null) {
                        contentType.append("; charset=").append(entity.getCharacterSet().getName());
                    }
                    responseHeaders.add("Content-Type", contentType.toString());
                }
                if (entity.getModificationDate() != null) {
                    responseHeaders.add("Last-Modified", response.getHttpCall().formatDate(entity.getModificationDate(), false));
                }
                if (entity.getTag() != null) {
                    responseHeaders.add("ETag", entity.getTag().format());
                }
                if (response.getEntity().getSize() != -1L) {
                    responseHeaders.add("Content-Length", Long.toString(response.getEntity().getSize()));
                }
                if (response.getEntity().getIdentifier() != null) {
                    responseHeaders.add("Content-Location", response.getEntity().getIdentifier().toString());
                }
            }
            if (!(response.getRequest().getClientInfo().getAgent() != null && response.getRequest().getClientInfo().getAgent().contains("MSIE") || (dimensions = response.getDimensions()).isEmpty())) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                if (dimensions.contains(Dimension.CLIENT_ADDRESS) || dimensions.contains(Dimension.TIME) || dimensions.contains(Dimension.UNSPECIFIED)) {
                    responseHeaders.add("Vary", "*");
                } else {
                    for (Dimension dim : response.getDimensions()) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(", ");
                        }
                        if (dim == Dimension.CHARACTER_SET) {
                            sb.append("Accept-Charset");
                            continue;
                        }
                        if (dim == Dimension.CLIENT_AGENT) {
                            sb.append("User-Agent");
                            continue;
                        }
                        if (dim == Dimension.ENCODING) {
                            sb.append("Accept-Encoding");
                            continue;
                        }
                        if (dim == Dimension.LANGUAGE) {
                            sb.append("Accept-Language");
                            continue;
                        }
                        if (dim != Dimension.MEDIA_TYPE) continue;
                        sb.append("Accept");
                    }
                    responseHeaders.add("Vary", sb.toString());
                }
            }
            Series additionalHeaders = (Series)response.getAttributes().get("org.restlet.http.headers");
            this.addAdditionalHeaders(responseHeaders, (Series<Parameter>)additionalHeaders);
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "Exception intercepted while adding the response headers", e);
            response.getHttpCall().setStatusCode(Status.SERVER_ERROR_INTERNAL.getCode());
            response.getHttpCall().setReasonPhrase(Status.SERVER_ERROR_INTERNAL.getDescription());
        }
    }
}

