/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.hibernate;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class ExtractFunction
implements SQLFunction {
    private static final String[] COMPONENTS = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "MILLIS"};
    private static final List<String> COMPONENTS_LIST = Arrays.asList(COMPONENTS);
    private static final String VALID_COMPONENTS = ExtractFunction.getValidComponents(COMPONENTS_LIST);
    private final Logger logger = Logger.getLogger(ExtractFunction.class.getName());
    private final String function;
    private final Type type;

    private static String getValidComponents(List<String> componentsList) {
        String temp = COMPONENTS_LIST.toString();
        return temp.substring(1, temp.length() - 1);
    }

    public ExtractFunction(String function, Type type) {
        function = function.toUpperCase();
        if (!COMPONENTS_LIST.contains(function)) {
            throw new QueryException("Expected one of " + VALID_COMPONENTS + " but received " + function);
        }
        this.function = function;
        this.type = type;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return false;
    }

    public Type getReturnType(Type firstArgumentType, Mapping mapping) throws QueryException {
        return this.type;
    }

    public String render(Type firstArgumentType, List arguments, SessionFactoryImplementor factory) throws QueryException {
        Object arg0 = arguments.get(0);
        this.logger.fine("arg = " + arg0 + " (" + arg0.getClass() + ')');
        String sql = "";
        switch (this.function) {
            case "YEAR": {
                sql = "cast(substring(cast(" + arg0 + " as TIMESTAMP), 1,4) as INTEGER)";
                break;
            }
            case "MONTH": {
                sql = "cast(substring(cast(" + arg0 + " as TIMESTAMP), 6,2) as INTEGER)";
                break;
            }
            case "DAY": {
                sql = "cast(substring(cast(" + arg0 + " as TIMESTAMP), 9,2) as INTEGER)";
                break;
            }
            case "HOUR": {
                sql = "cast(substring(cast(" + arg0 + " as TIMESTAMP), 12,2) as INTEGER)";
                break;
            }
            case "MINUTE": {
                sql = "cast(substring(cast(" + arg0 + " as TIMESTAMP), 15,2) as INTEGER)";
                break;
            }
            case "SECOND": {
                sql = "cast(substring(cast(" + arg0 + " as TIMESTAMP), 18,2) as INTEGER)";
                break;
            }
            case "MILLIS": {
                sql = "cast(substring(cast(" + arg0 + " as TIMESTAMP), 21,6) as INTEGER)";
            }
        }
        this.logger.fine("Extract (" + this.function + "): " + sql);
        return sql;
    }
}

