/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.hibernate;

import com.nuodb.hibernate.ExtractFunction;
import com.nuodb.hibernate.NuoDBLimitHandler;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.ScrollMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupportImpl;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.tool.schema.extract.internal.SequenceInformationImpl;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class NuoDBDialect
extends Dialect {
    public static final String SELECT_UUID = "SELECT uuid()";
    public static final String USE_NUODB_STRING_COLUMN_TYPE = "USE_NUODB_STRING_COLUMN_TYPE";
    public static final int MINIMUM_QUANTUM_SIZE = 10;
    public static final int MAXIMUM_QUANTUM_SIZE = 65535;
    public static final String GENERATED_BY_DEFAULT_AS_IDENTITY_NOT_NULL = " GENERATED BY DEFAULT AS IDENTITY NOT NULL ";
    public static final String ADD_COLUMN = " ADD COLUMN ";
    public static final String CASCADE = " CASCADE ";
    private static final String CROSS_JOIN_SEPARATOR = ", ";
    public static final String DEFAULT_VALUES = "DEFAULT VALUES ";
    public static final String DROP_CONSTRAINT_FOREIGN = " DROP CONSTRAINT ";
    public static final String FOR_UPDATE = " FOR UPDATE ";
    private static final String FOR_UPDATE_NO_WAIT = " FOR UPDATE  NOWAIT ";
    public static final String FOR_UPDATE_SKIP_LOCKED = " FOR UPDATE  SKIP LOCKED ";
    public static final String NULL = " NULL ";
    private static final String SELECT_CURRENT_SCHEMA_FROM_DUAL = " SELECT CURRENT_SCHEMA FROM DUAL ";
    public static final String SELECT_CURRENT_TIMESTAMP_FROM_DUAL = " SELECT CURRENT_TIMESTAMP FROM DUAL ";
    private static final Logger LOGGER = Logger.getLogger(NuoDBDialect.class.getName());
    private static boolean useStringInsteadOfVarchar = false;

    public static void useStringInsteadOfVarchar(boolean enabled) {
        useStringInsteadOfVarchar = enabled;
    }

    private static int quantumSize(int requestedSize) {
        if (requestedSize < 10) {
            return 10;
        }
        if (requestedSize > 65535) {
            return 65535;
        }
        return requestedSize;
    }

    public NuoDBDialect() {
        LOGGER.info("Using NuoDB Dialect for Hibernate 5");
        String useNuoDBStrings = System.getenv(USE_NUODB_STRING_COLUMN_TYPE);
        if (useNuoDBStrings == null) {
            useNuoDBStrings = System.getProperty(USE_NUODB_STRING_COLUMN_TYPE);
        }
        if (useNuoDBStrings != null && !useNuoDBStrings.equalsIgnoreCase("false")) {
            useStringInsteadOfVarchar = true;
        }
        this.registerTypes();
        this.registerFunctions();
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "true");
        this.getDefaultProperties().setProperty("hibernate.max_fetch_depth", "2");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    protected void registerTypes() {
        this.registerColumnType(-7, "SMALLINT");
        this.registerColumnType(-6, "SMALLINT");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(6, "float");
        this.registerColumnType(7, "REAL");
        this.registerColumnType(8, "DOUBLE");
        this.registerColumnType(2, "NUMERIC($p, $s)");
        this.registerColumnType(3, "DECIMAL($p, $s)");
        this.registerColumnType(1, "CHARACTER");
        this.registerColumnType(12, "VARCHAR ($l)");
        this.registerColumnType(-1, "VARCHAR ($l)");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(-2, "BINARY ($l)");
        this.registerColumnType(-3, "BINARY VARYING ($l)");
        this.registerColumnType(-4, "BINARY VARYING ($l)");
        this.registerColumnType(0, "NULL");
        this.registerColumnType(2004, "BINARY LARGE OBJECT");
        this.registerColumnType(2005, "CHARACTER LARGE OBJECT");
        this.registerColumnType(16, "BOOLEAN");
        this.registerColumnType(-15, "NATIONAL CHARACTER");
        this.registerColumnType(-9, "NATIONAL CHARACTER VARYING ($l)");
        this.registerColumnType(2011, "NATIONAL CHARACTER LARGE OBJECT");
    }

    protected void registerFunctions() {
        this.registerFunction("hour", new ExtractFunction("HOUR", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("minute", new ExtractFunction("MINUTE", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("second", new ExtractFunction("SECOND", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("year", new ExtractFunction("YEAR", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("month", new ExtractFunction("MONTH", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("day", new ExtractFunction("DAY", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("current_date", (Type)StandardBasicTypes.DATE, false));
        this.registerFunction("current_time", (SQLFunction)new NoArgSQLFunction("current_time", (Type)StandardBasicTypes.TIME, false));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("current_timestamp", (Type)StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("millis", new ExtractFunction("MILLIS", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("str", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.STRING, "cast(?1 as string)"));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "", "||", ""));
    }

    public String getTypeName(int code) throws HibernateException {
        String typeName = useStringInsteadOfVarchar && (code == 12 || code == -1) ? "STRING" : super.getTypeName(code);
        return typeName;
    }

    public String getTypeName(int code, long length, int precision, int scale) throws HibernateException {
        String typeName = useStringInsteadOfVarchar && (code == 12 || code == -1) ? "STRING" : super.getTypeName(code, length, precision, scale);
        return typeName;
    }

    public String getCurrentTimestampSelectString() {
        return SELECT_CURRENT_TIMESTAMP_FROM_DUAL;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            public JDBCException convert(SQLException sqlException, String message, String sql) {
                if ("58000".equals(sqlException.getSQLState()) && sqlException.getMessage().contains("illegal null")) {
                    return new ConstraintViolationException(message, sqlException, null);
                }
                return null;
            }
        };
    }

    public String getNoColumnsInsertString() {
        return DEFAULT_VALUES;
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "true" : "false";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getAddColumnString() {
        return ADD_COLUMN;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return new IdentityColumnSupportImpl(){

            public boolean supportsIdentityColumns() {
                return true;
            }

            public boolean hasDataTypeInIdentityColumn() {
                return false;
            }

            public String getIdentitySelectString(String table, String column, int type) throws MappingException {
                throw new MappingException(((Object)((Object)this)).getClass().getName() + ": unexpected call to getIdentitySelectString()");
            }

            public String getIdentityColumnString(int type) throws MappingException {
                switch (type) {
                    case 4: {
                        return "INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL ";
                    }
                    case -5: {
                        return "BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL ";
                    }
                    case 3: {
                        return "DECIMAL GENERATED BY DEFAULT AS IDENTITY NOT NULL ";
                    }
                    case 12: {
                        return "STRING GENERATED BY DEFAULT AS IDENTITY NOT NULL ";
                    }
                }
                throw new MappingException("Identity column not supported for SQL type:" + NuoDBDialect.this.getHibernateTypeName(type) + " (" + type + ')');
            }
        };
    }

    public boolean supportsSequences() {
        LOGGER.fine("Supports sequences? true");
        return true;
    }

    public String getSequenceNextValString(String sequenceName) throws MappingException {
        return "select cast(next value for " + sequenceName + " as bigint) from dual";
    }

    public String getSelectSequenceNextValString(String sequenceName) throws MappingException {
        return "(select cast(next value for " + sequenceName + " as bigint) from dual)";
    }

    protected String getDropSequenceString(String sequenceName) throws MappingException {
        return "drop sequence " + sequenceName + " if exists";
    }

    public String getQuerySequencesString() {
        String sql = "SELECT '' as sequence_catalog, schema as sequence_schema, sequencename as sequence_name, -1 as start_value, 1 as minimum_value, 9223372036854775807 as maximum_value, 1 as increment FROM System.sequences";
        LOGGER.fine("SEQUENCES: " + sql);
        return sql;
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return NuoDbSequenceInformationExtractor.INSTANCE;
    }

    protected String getCreateSequenceString(String sequenceName) throws MappingException {
        LOGGER.fine("getCreateSequenceString0: create sequence " + sequenceName);
        return "create sequence " + sequenceName + " /* creatSeqStr-0 */";
    }

    public boolean supportsPooledSequences() {
        LOGGER.fine("Supports pooled sequences? false");
        return false;
    }

    protected String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) throws MappingException {
        LOGGER.fine("getCreateSequenceString1: initialValue: " + initialValue + " incrementSize: " + incrementSize + " (used to set QUANTUM SIZE)");
        return "CREATE SEQUENCE " + sequenceName + " /* creatSeqStr-1 */ START WITH " + initialValue + ", QUANTUM SIZE " + NuoDBDialect.quantumSize(incrementSize);
    }

    @Deprecated
    public String[] getCreateSequenceStrings(String sequenceName, int initialValue, int incrementSize) throws MappingException {
        LOGGER.fine("getCreateSequenceString2: initialValue: " + initialValue + " incrementSize: " + incrementSize + " (used to set QUANTUM SIZE)");
        String createSql = "CREATE SEQUENCE " + sequenceName + " /* creatSeqStr-2 */ START WITH " + initialValue + ", QUANTUM SIZE " + NuoDBDialect.quantumSize(incrementSize);
        return new String[]{createSql};
    }

    public LimitHandler getLimitHandler() {
        return new NuoDBLimitHandler();
    }

    @Deprecated
    public boolean supportsLimit() {
        return true;
    }

    @Deprecated
    public boolean supportsLimitOffset() {
        return true;
    }

    @Deprecated
    public boolean supportsVariableLimit() {
        return false;
    }

    @Deprecated
    public String getLimitString(String sql, int offset, int limit) {
        return NuoDBLimitHandler.addLimitToSQL(sql, offset, limit);
    }

    public String getAlterTableString(String tableName) {
        return super.getAlterTableString(tableName);
    }

    public boolean supportsIfExistsAfterAlterTable() {
        return false;
    }

    public boolean dropConstraints() {
        return true;
    }

    public String getDropForeignKeyString() {
        return DROP_CONSTRAINT_FOREIGN;
    }

    public String getCascadeConstraintsString() {
        return CASCADE;
    }

    public String getNullColumnString() {
        return NULL;
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return true;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public String getSelectGUIDString() {
        return SELECT_UUID;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public String getCrossJoinSeparator() {
        return CROSS_JOIN_SEPARATOR;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    public boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    public String getForUpdateString() {
        LOGGER.fine(" >> >> >> FOR UPDATE 1");
        return FOR_UPDATE;
    }

    public boolean supportsSkipLocked() {
        return true;
    }

    public boolean supportsNoWait() {
        return true;
    }

    public String getWriteLockString(int timeout) {
        LOGGER.fine(" >> >> >> FOR UPDATE 2");
        return FOR_UPDATE;
    }

    public String getForUpdateNowaitString() {
        LOGGER.fine(" >>> >>> >>> NO WAIT!!");
        return FOR_UPDATE_NO_WAIT;
    }

    public String getForUpdateSkipLockedString() {
        return FOR_UPDATE_SKIP_LOCKED;
    }

    public String getReadLockString(int timeout) {
        return "";
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean areStringComparisonsCaseInsensitive() {
        return false;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public String getCurrentSchemaCommand() {
        return SELECT_CURRENT_SCHEMA_FROM_DUAL;
    }

    public boolean supportsSubqueryOnMutatingTable() {
        return false;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public ScrollMode defaultScrollMode() {
        return ScrollMode.FORWARD_ONLY;
    }

    public boolean supportsTuplesInSubqueries() {
        return false;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT || lockMode == LockMode.PESSIMISTIC_WRITE || lockMode == LockMode.PESSIMISTIC_READ || lockMode == LockMode.OPTIMISTIC || lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return super.getLockingStrategy(lockable, lockMode);
        }
        return new NuoDBSelectLockingStrategy(lockable, lockMode);
    }

    protected static class NuoDBSelectLockingStrategy
    extends SelectLockingStrategy {
        public NuoDBSelectLockingStrategy(Lockable lockable, LockMode lockMode) {
            super(lockable, lockMode);
        }

        public void lock(Serializable id, Object version, Object object, int timeout, SessionImplementor session) throws StaleObjectStateException, JDBCException {
            try {
                super.lock(id, version, object, timeout, (SharedSessionContractImplementor)session);
            }
            catch (StaleStateException sse) {
                throw new StaleObjectStateException(this.getLockable().getEntityName(), id);
            }
        }
    }

    protected static class NuoDbSequenceInformationExtractor
    implements SequenceInformationExtractor {
        protected static final NuoDbSequenceInformationExtractor INSTANCE = new NuoDbSequenceInformationExtractor();

        protected NuoDbSequenceInformationExtractor() {
        }

        /*
         * Exception decompiling
         */
        public Iterable<SequenceInformation> extractMetadata(ExtractionContext extractionContext) throws SQLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected Constructor<?> getSeqInfoConstructor() {
            Constructor<?>[] constructors = SequenceInformationImpl.class.getConstructors();
            Constructor<?> ctr = constructors[0];
            LOGGER.fine("Using " + ctr.getGenericParameterTypes().length + " arg SequenceInformationImpl ctr");
            return ctr;
        }

        protected void addSeqInfo(List<SequenceInformation> sequenceInformationList, Constructor<?> ctr, QualifiedSequenceName qualifiedSequenceName, int increment) {
            LOGGER.fine("SequenceInformation constructor has " + ctr.getParameterCount() + " parameters");
            boolean use2ArgCtr = ctr.getParameterCount() == 2;
            try {
                SequenceInformation seqInfo = use2ArgCtr ? (SequenceInformation)ctr.newInstance(qualifiedSequenceName, increment) : (SequenceInformation)ctr.newInstance(qualifiedSequenceName, 0L, 0L, Integer.MAX_VALUE, increment);
                sequenceInformationList.add(seqInfo);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LOGGER.severe("Unable to save information for sequence " + qualifiedSequenceName.getSchemaName() + "." + qualifiedSequenceName.getSequenceName());
                LOGGER.severe("   Trying to use ctr " + ctr);
                LOGGER.severe("    Exeception: " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
    }
}

