/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.hibernate;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;

public class NuoDBLimitHandler
extends AbstractLimitHandler {
    public static String addLimitToSQL(String sql, int offset, int limit) {
        String sqlString = sql.trim();
        boolean isForUpdate = false;
        int ix = sqlString.toUpperCase().indexOf(" FOR UPDATE ".trim());
        String forUpdate = "";
        if (ix != -1) {
            forUpdate = sqlString.substring(ix).trim();
            sqlString = sqlString.substring(0, ix).trim();
            isForUpdate = true;
        }
        StringBuilder sb = new StringBuilder(sqlString.length() + 30);
        sb.append(sqlString);
        sb.append(" OFFSET ");
        sb.append(offset);
        sb.append(" FETCH FIRST ");
        sb.append(limit);
        if (isForUpdate) {
            sb.append(' ');
            sb.append(forUpdate);
        }
        return sb.toString();
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public boolean forceLimitUsage() {
        return false;
    }

    public int convertToFirstRowValue(int zeroBasedFirstResult) {
        return zeroBasedFirstResult;
    }

    public String processSql(String sql, RowSelection selection) {
        boolean useLimitOffset = this.supportsLimit() && this.supportsLimitOffset() && LimitHelper.hasFirstRow((RowSelection)selection) && LimitHelper.hasMaxRows((RowSelection)selection);
        return NuoDBLimitHandler.addLimitToSQL(sql, useLimitOffset ? LimitHelper.getFirstRow((RowSelection)selection) : 0, this.getMaxOrLimit(selection));
    }
}

