/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.hibernate;

import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.logger.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

public class NuoHibernateConnection
extends RemConnection {
    protected Class<?> staleStateExceptionClass = null;
    protected Constructor<?> staleStateExceptionConstructor;

    protected NuoHibernateConnection(RemConnection.ErrorHandler errorHandler, Logger logger) {
        super(errorHandler, logger);
        try {
            this.staleStateExceptionClass = Class.forName("org.hibernate.StaleStateException");
            this.staleStateExceptionConstructor = this.staleStateExceptionClass.getConstructor(String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }

    public void sendAndReceive(EncodedDataStream stream) throws SQLException {
        try {
            super.sendAndReceive(stream);
        }
        catch (SQLException sqle) {
            String sqlState = sqle.getSQLState();
            int sqlCode = sqle.getErrorCode();
            for (SQLException nested = sqle.getNextException(); sqlState == null && nested != null; nested = nested.getNextException()) {
                sqlState = nested.getSQLState();
                sqlCode = nested.getErrorCode();
            }
            if (sqlState != null && this.staleStateExceptionClass != null && sqlState.equals(SQLState.UPDATE_CONFLICT.getState()) && sqlCode == SQLState.UPDATE_CONFLICT.getCode()) {
                try {
                    throw (RuntimeException)this.staleStateExceptionConstructor.newInstance(sqle.getMessage());
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            throw sqle;
        }
    }
}

