/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.agent;

import com.google.protobuf.Empty;
import com.objective.threesixty.CheckboxField;
import com.objective.threesixty.ConnectorFormConfigGrpc;
import com.objective.threesixty.Field;
import com.objective.threesixty.FormConfigRequest;
import com.objective.threesixty.NumberField;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.ObjectiveCallbackGrpc;
import com.objective.threesixty.Response;
import com.objective.threesixty.Value;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.ConnectorForm;
import com.objective.threesixty.remoteagent.sdk.agent.Reader;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import com.objective.threesixty.remoteagent.sdk.utils.CustomParameters;
import com.objective.threesixty.remoteagent.sdk.utils.ReservedIdentifier;
import com.objective.threesixty.remoteagent.sdk.utils.ValueUtils;
import io.grpc.Channel;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class BaseAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAgent.class);
    private final ApplicationContext applicationContext;
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;
    private final Reader reader;
    private final ConnectorForm connectorForm;
    private Map<ObjectiveActionType, Action> actions;

    @PostConstruct
    private void connect() {
        try {
            this.commsManager.initialize();
            if (!this.commsManager.verifyAgentToken()) {
                log.error("Agent token verification failed");
                throw new RuntimeException("Agent token verification failed");
            }
            log.info("Agent token verification successful for agent: {}", (Object)this.agentProperties.getAgentName());
            this.actions = this.applicationContext.getBeansOfType(Action.class).values().stream().collect(Collectors.toMap(Action::getActionType, action -> action));
            this.sendContactDetails();
            this.configureConnectorForms(this.connectorForm.getSourceRepositoryFields(), this.connectorForm.getContentServiceFields());
        }
        catch (StatusRuntimeException e) {
            this.handleFailedInitialConnection("Failed to connect to the server in time. Check that 3Sixty has started, or increase the 'validate-agent-token-rpc' timeout.", (Exception)((Object)e));
        }
        catch (IOException | GeneralSecurityException e) {
            this.handleFailedInitialConnection("Error setting up SSL.", e);
        }
        catch (Exception e) {
            this.handleFailedInitialConnection("Error during Remote Server Communication.", e);
        }
    }

    private void handleFailedInitialConnection(String message, Exception e) {
        log.error(message, (Throwable)e);
        SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
    }

    @Scheduled(fixedRateString="PT2M")
    private void sendContactDetails() {
        ObjectiveCallbackGrpc.ObjectiveCallbackStub objectiveCallbackStub = ObjectiveCallbackGrpc.newStub((Channel)this.commsManager.getChannel());
        StreamObserver objectiveCallbackOpenLine = objectiveCallbackStub.initiateObjectiveAction((StreamObserver)new StreamObserver<ObjectiveAction>(){

            public void onNext(ObjectiveAction value) {
                try {
                    BaseAgent.this.actions.get(value.getType()).execute(BaseAgent.this.reader, value);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }

            public void onError(Throwable t) {
                log.error("Error from Server: {}", (Object)t.getMessage(), (Object)t);
                throw new RuntimeException(t);
            }

            public void onCompleted() {
            }
        });
        objectiveCallbackOpenLine.onNext((Object)Empty.getDefaultInstance());
    }

    private void configureConnectorForms(List<Field> sourceRepositoryFields, List<Field> csConnectorFields) {
        ConnectorFormConfigGrpc.ConnectorFormConfigBlockingStub formConfigBlockingStub = ConnectorFormConfigGrpc.newBlockingStub((Channel)this.commsManager.getChannel());
        log.debug("Request sent to 3Sixty server to configure the Connector Form");
        FormConfigRequest.Builder builder = FormConfigRequest.newBuilder();
        Field includeHash = Field.newBuilder().setLabel("Include Binary Hash").setDescription("Compare the MD5 hash of the file before and after remote transfer").setId(ReservedIdentifier.INCLUDE_HASH_PARAM.getName()).setCheckboxField(CheckboxField.newBuilder().build()).build();
        CustomParameters p = new CustomParameters(new HashMap<String, Value>());
        p.put(ReservedIdentifier.INCLUDE_HASH_PARAM.getName(), ValueUtils.booleanValue(true));
        long upperFileSizeHashLimit = p.getMaxFileSizeHash();
        Field maxFileSizeHash = Field.newBuilder().setLabel("Max File Size Hash").setDescription("Do not generate hash for file size exceeding this size limit (megabyte). Max: " + upperFileSizeHashLimit).setId(ReservedIdentifier.MAX_FILE_SIZE_HASH.getName()).setDependsOn(ReservedIdentifier.INCLUDE_HASH_PARAM.getName()).setNumberField(NumberField.newBuilder().setMin(0L).setMax(upperFileSizeHashLimit).build()).build();
        if (null != sourceRepositoryFields) {
            builder.addAllRepoFields(sourceRepositoryFields);
        }
        builder.addRepoFields(includeHash);
        builder.addRepoFields(maxFileSizeHash);
        if (null != csConnectorFields) {
            builder.addAllContentServiceFields(csConnectorFields);
        }
        Response response = ((ConnectorFormConfigGrpc.ConnectorFormConfigBlockingStub)formConfigBlockingStub.withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getConfigureConnectorFormRpc(), TimeUnit.SECONDS)).configureConnectorForm(builder.build());
        log.debug("Response from 3Sixty (Configuring Connector Forms): {}", (Object)response.getStatus());
    }

    @Generated
    public BaseAgent(ApplicationContext applicationContext, CommunicationsManager commsManager, RemoteAgentProperties agentProperties, Reader reader, ConnectorForm connectorForm) {
        this.applicationContext = applicationContext;
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
        this.reader = reader;
        this.connectorForm = connectorForm;
    }
}

