/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.utils;

import com.objective.threesixty.Response;
import com.objective.threesixty.TokenValidationRequest;
import com.objective.threesixty.ValidatorGrpc;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CertificateUtils;
import com.objective.threesixty.remoteagent.sdk.utils.HeaderClientInterceptor;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.netty.handler.ssl.SslContext;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;

@Component
public final class CommunicationsManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommunicationsManager.class);
    private static final String BASE_ENDPOINT = "/api/public/remoteagents/jobruns/documents/chunk/";
    private static final String CHUNKED_UPLOAD_ENDPOINT = "/api/public/remoteagents/jobruns/documents/chunk/upload";
    private static final String COMPLETE_FILE_UPLOAD_ENDPOINT = "/api/public/remoteagents/jobruns/documents/chunk/complete";
    private static final String CANCEL_FILE_UPLOAD_ENDPOINT = "/api/public/remoteagents/jobruns/documents/chunk/cancel";
    private final RemoteAgentProperties agentProperties;
    private ManagedChannel channel;
    private WebClient webClient;

    public void initialize() throws GeneralSecurityException, IOException {
        TrustManagerFactory tmf = null;
        if (this.agentProperties.getSslConfig().isEnabled() || this.agentProperties.getServerUrl().startsWith("https")) {
            tmf = CertificateUtils.getTrustManagerFactory(this.agentProperties.getSslConfig().getCaCerts().getPassword());
        }
        this.initializeManagedChannel(tmf);
        this.initializeWebClient(tmf);
    }

    private void initializeManagedChannel(TrustManagerFactory tmf) {
        ManagedChannelBuilder channelBuilder;
        HeaderClientInterceptor interceptor = new HeaderClientInterceptor(this.agentProperties.getToken());
        RemoteAgentProperties.GrpcServer grpcServer = this.agentProperties.getGrpcServer();
        if (this.agentProperties.getSslConfig().isEnabled()) {
            log.info("gRPC SSL is enabled, connecting with secured channel");
            channelBuilder = Grpc.newChannelBuilderForAddress((String)grpcServer.getHost(), (int)grpcServer.getPort(), (ChannelCredentials)CertificateUtils.getChannelCredentials(tmf));
        } else {
            log.info("gRPC SSL is not enabled, connecting with plain text");
            channelBuilder = ManagedChannelBuilder.forAddress((String)grpcServer.getHost(), (int)grpcServer.getPort()).usePlaintext();
        }
        this.channel = channelBuilder.intercept(new ClientInterceptor[]{interceptor}).build();
    }

    private void initializeWebClient(TrustManagerFactory tmf) throws SSLException {
        WebClient.Builder webClientBuilder = WebClient.builder().baseUrl(this.agentProperties.getSanitizedServerUrl());
        if (this.agentProperties.getServerUrl().startsWith("https")) {
            log.info("SSL protocol found for Tomcat's REST url, configuring web client with SSL context");
            SslContext sslContext = CertificateUtils.getSslContext(tmf);
            HttpClient httpClient = HttpClient.create().secure(sslContextSpec -> sslContextSpec.sslContext(sslContext));
            webClientBuilder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient));
        } else {
            log.info("No SSL protocol found for Tomcat's REST url");
        }
        this.webClient = webClientBuilder.build();
    }

    @PreDestroy
    private void shutdown() {
        log.info("Shutting down ManagedChannel...");
        this.channel.shutdownNow();
    }

    public boolean verifyAgentToken() {
        ValidatorGrpc.ValidatorBlockingStub validatorBlockingStub = ValidatorGrpc.newBlockingStub((Channel)this.getChannel());
        TokenValidationRequest request = TokenValidationRequest.newBuilder().setToken(this.agentProperties.getToken()).setAgentName(this.agentProperties.getAgentName()).build();
        RemoteAgentProperties.GrpcServer grpcServer = this.agentProperties.getGrpcServer();
        log.info("Waiting for gRPC server [Host: {}, Port: {}] to be ready before validating agent credentials", (Object)grpcServer.getHost(), (Object)grpcServer.getPort());
        Response response = ((ValidatorGrpc.ValidatorBlockingStub)((ValidatorGrpc.ValidatorBlockingStub)validatorBlockingStub.withWaitForReady()).withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getValidateAgentTokenRpc(), TimeUnit.SECONDS)).validateAgentToken(request);
        if (Response.ResponseStatus.RESPONSE_STATUS_SUCCESS.equals((Object)response.getStatus())) {
            return true;
        }
        log.error("Agent token validation failed: {}", (Object)response.getMessage());
        return false;
    }

    public String getChunkedUploadEndpoint() {
        return CHUNKED_UPLOAD_ENDPOINT;
    }

    public String getCompleteFileUploadEndpoint() {
        return COMPLETE_FILE_UPLOAD_ENDPOINT;
    }

    public String getCancelFileUploadEndpoint() {
        return CANCEL_FILE_UPLOAD_ENDPOINT;
    }

    @Generated
    public CommunicationsManager(RemoteAgentProperties agentProperties) {
        this.agentProperties = agentProperties;
    }

    @Generated
    public ManagedChannel getChannel() {
        return this.channel;
    }

    @Generated
    public WebClient getWebClient() {
        return this.webClient;
    }
}

