/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.action;

import com.objective.threesixty.DocumentMetadata;
import com.objective.threesixty.MetadataType;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.RepositoryReader;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import com.objective.threesixty.remoteagent.sdk.utils.CustomParameters;
import com.objective.threesixty.remoteagent.sdk.utils.StatusUtils;
import com.objective.threesixty.remoteagent.sdk.utils.StreamObserverFactory;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public final class MetadataAction
implements Action {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;
    private final RepositoryReader reader;

    @Override
    public void execute(ObjectiveAction action) {
        CustomParameters parameters = new CustomParameters(action.getValueByIdMap());
        String docId = parameters.getDocId();
        StreamObserver<DocumentMetadata> requestObserver = StreamObserverFactory.createDocumentMetadataObserver(this.commsManager.getChannel(), this.agentProperties.getGrpcServer().getTimeouts().getShareDocumentMetadataRpc(), action.getRequestId());
        DocumentMetadata.Builder builder = DocumentMetadata.newBuilder().setRequestId(action.getRequestId()).setDocId(docId);
        try {
            Map<String, MetadataType> metadata = this.reader.getDocumentMetadata(docId, parameters);
            builder.putAllDocMetadata(metadata).setStatus(StatusUtils.success("Success"));
        }
        catch (Exception e) {
            this.log.error("Error getting metadata for source document: {}", (Object)docId, (Object)e);
            HashMap metadataTypeMap = new HashMap();
            builder.putAllDocMetadata(metadataTypeMap).setStatus(StatusUtils.failure(e.getMessage()));
        }
        DocumentMetadata request = builder.build();
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
    }

    @Override
    public ObjectiveActionType getActionType() {
        return ObjectiveActionType.OBJECTIVE_ACTION_METADATA;
    }

    @Generated
    public MetadataAction(CommunicationsManager commsManager, RemoteAgentProperties agentProperties, RepositoryReader reader) {
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
        this.reader = reader;
    }
}

