/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

final class MimeMap {
    private static final HashMap<String, String> mimes = new HashMap();
    private static final String AUDIO_X_AIFF = "audio/x-aiff";
    private static final String APPLICATION_POSTSCRIPT = "application/postscript";
    private static final String APPLICATION_VND_MS_EXCEL = "application/vnd.ms-excel";
    private static final String APPLICATION_VND_MS_WORKS = "application/vnd.ms-works";
    private static final String APPLICATION_VND_MS_POWERPOINT = "application/vnd.ms-powerpoint";
    private static final String APPLICATION_X_DIRECTOR = "application/x-director";
    private static final String APPLICATION_X_MSMEDIAVIEW = "application/x-msmediaview";
    private static final String APPLICATION_X_PERFMON = "application/x-perfmon";
    private static final String APPLICATION_X_TROFF = "application/x-troff";
    private static final String APPLICATION_X_X509_CA_CERT = "application/x-x509-ca-cert";
    private static final String MESSAGE_RFC822 = "message/rfc822";
    private static final String VIDEO_MPEG = "video/mpeg";
    private static final String VIDEO_X_MS_ASF = "video/x-ms-asf";
    private static final String X_WORLD_X_VRML = "x-world/x-vrml";

    static String getMimeTypeForExtension(String extension) {
        Optional<String> mimeType = mimes.entrySet().stream().filter(entry -> extension.equals(entry.getKey())).map(Map.Entry::getValue).findAny();
        return mimeType.orElse("application/octet-stream");
    }

    @Generated
    private MimeMap() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        mimes.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        mimes.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        mimes.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        mimes.put("323", "text/h323");
        mimes.put("acx", "application/internet-property-stream");
        mimes.put("ai", APPLICATION_POSTSCRIPT);
        mimes.put("aif", AUDIO_X_AIFF);
        mimes.put("aifc", AUDIO_X_AIFF);
        mimes.put("aiff", AUDIO_X_AIFF);
        mimes.put("asf", VIDEO_X_MS_ASF);
        mimes.put("asr", VIDEO_X_MS_ASF);
        mimes.put("asx", VIDEO_X_MS_ASF);
        mimes.put("au", "audio/basic");
        mimes.put("avi", "video/x-msvideo");
        mimes.put("axs", "application/olescript");
        mimes.put("bas", "text/plain");
        mimes.put("bcpio", "application/x-bcpio");
        mimes.put("bin", "application/octet-stream");
        mimes.put("bmp", "image/bmp");
        mimes.put("c", "text/plain");
        mimes.put("cat", "application/vnd.ms-pkiseccat");
        mimes.put("cdf", "application/x-cdf");
        mimes.put("cer", APPLICATION_X_X509_CA_CERT);
        mimes.put("class", "application/octet-stream");
        mimes.put("clp", "application/x-msclip");
        mimes.put("cmx", "image/x-cmx");
        mimes.put("cod", "image/cis-cod");
        mimes.put("cpio", "application/x-cpio");
        mimes.put("crd", "application/x-mscardfile");
        mimes.put("crl", "application/pkix-crl");
        mimes.put("crt", APPLICATION_X_X509_CA_CERT);
        mimes.put("csh", "application/x-csh");
        mimes.put("css", "text/css");
        mimes.put("dcr", APPLICATION_X_DIRECTOR);
        mimes.put("der", APPLICATION_X_X509_CA_CERT);
        mimes.put("dir", APPLICATION_X_DIRECTOR);
        mimes.put("dll", "application/x-msdownload");
        mimes.put("dms", "application/octet-stream");
        mimes.put("doc", "application/msword");
        mimes.put("dot", "application/msword");
        mimes.put("dvi", "application/x-dvi");
        mimes.put("dxr", APPLICATION_X_DIRECTOR);
        mimes.put("eps", APPLICATION_POSTSCRIPT);
        mimes.put("etx", "text/x-setext");
        mimes.put("evy", "application/envoy");
        mimes.put("exe", "application/octet-stream");
        mimes.put("fif", "application/fractals");
        mimes.put("flr", X_WORLD_X_VRML);
        mimes.put("gif", "image/gif");
        mimes.put("gtar", "application/x-gtar");
        mimes.put("gz", "application/x-gzip");
        mimes.put("h", "text/plain");
        mimes.put("hdf", "application/x-hdf");
        mimes.put("hlp", "application/winhlp");
        mimes.put("hqx", "application/mac-binhex40");
        mimes.put("hta", "application/hta");
        mimes.put("htc", "text/x-component");
        mimes.put("htm", "text/html");
        mimes.put("html", "text/html");
        mimes.put("htt", "text/webviewhtml");
        mimes.put("ico", "image/x-icon");
        mimes.put("ief", "image/ief");
        mimes.put("iii", "application/x-iphone");
        mimes.put("ins", "application/x-internet-signup");
        mimes.put("isp", "application/x-internet-signup");
        mimes.put("jfif", "image/pipeg");
        mimes.put("jpe", "image/jpeg");
        mimes.put("jpeg", "image/jpeg");
        mimes.put("jpg", "image/jpeg");
        mimes.put("js", "application/x-javascript");
        mimes.put("latex", "application/x-latex");
        mimes.put("lha", "application/octet-stream");
        mimes.put("lsf", "video/x-la-asf");
        mimes.put("lsx", "video/x-la-asf");
        mimes.put("lzh", "application/octet-stream");
        mimes.put("m13", APPLICATION_X_MSMEDIAVIEW);
        mimes.put("m14", APPLICATION_X_MSMEDIAVIEW);
        mimes.put("m3u", "audio/x-mpegurl");
        mimes.put("man", "application/x-troff-man");
        mimes.put("mdb", "application/x-msaccess");
        mimes.put("me", "application/x-troff-me");
        mimes.put("mht", MESSAGE_RFC822);
        mimes.put("mhtml", MESSAGE_RFC822);
        mimes.put("mid", "audio/mid");
        mimes.put("mny", "application/x-msmoney");
        mimes.put("mov", "video/quicktime");
        mimes.put("movie", "video/x-sgi-movie");
        mimes.put("mp2", VIDEO_MPEG);
        mimes.put("mp3", "audio/mpeg");
        mimes.put("mp4", "video/mp4");
        mimes.put("mpa", VIDEO_MPEG);
        mimes.put("mpe", VIDEO_MPEG);
        mimes.put("mpeg", VIDEO_MPEG);
        mimes.put("mpg", VIDEO_MPEG);
        mimes.put("mpp", "application/vnd.ms-project");
        mimes.put("mpv2", VIDEO_MPEG);
        mimes.put("ms", "application/x-troff-ms");
        mimes.put("msg", "application/vnd.ms-outlook");
        mimes.put("mvb", APPLICATION_X_MSMEDIAVIEW);
        mimes.put("nc", "application/x-netcdf");
        mimes.put("nws", MESSAGE_RFC822);
        mimes.put("oda", "application/oda");
        mimes.put("p10", "application/pkcs10");
        mimes.put("p12", "application/x-pkcs12");
        mimes.put("p7b", "application/x-pkcs7-certificates");
        mimes.put("p7c", "application/x-pkcs7-mime");
        mimes.put("p7m", "application/x-pkcs7-mime");
        mimes.put("p7r", "application/x-pkcs7-certreqresp");
        mimes.put("p7s", "application/x-pkcs7-signature");
        mimes.put("pbm", "image/x-portable-bitmap");
        mimes.put("pdf", "application/pdf");
        mimes.put("pfx", "application/x-pkcs12");
        mimes.put("pgm", "image/x-portable-graymap");
        mimes.put("pko", "application/ynd.ms-pkipko");
        mimes.put("pma", APPLICATION_X_PERFMON);
        mimes.put("pmc", APPLICATION_X_PERFMON);
        mimes.put("pml", APPLICATION_X_PERFMON);
        mimes.put("pmr", APPLICATION_X_PERFMON);
        mimes.put("pmw", APPLICATION_X_PERFMON);
        mimes.put("pnm", "image/x-portable-anymap");
        mimes.put("pot", APPLICATION_VND_MS_POWERPOINT);
        mimes.put("ppm", "image/x-portable-pixmap");
        mimes.put("pps", APPLICATION_VND_MS_POWERPOINT);
        mimes.put("ppt", APPLICATION_VND_MS_POWERPOINT);
        mimes.put("prf", "application/pics-rules");
        mimes.put("ps", APPLICATION_POSTSCRIPT);
        mimes.put("pub", "application/x-mspublisher");
        mimes.put("qt", "video/quicktime");
        mimes.put("ra", "audio/x-pn-realaudio");
        mimes.put("ram", "audio/x-pn-realaudio");
        mimes.put("ras", "image/x-cmu-raster");
        mimes.put("rgb", "image/x-rgb");
        mimes.put("rmi", "audio/mid");
        mimes.put("roff", APPLICATION_X_TROFF);
        mimes.put("rtf", "application/rtf");
        mimes.put("rtx", "text/richtext");
        mimes.put("scd", "application/x-msschedule");
        mimes.put("sct", "text/scriptlet");
        mimes.put("setpay", "application/set-payment-initiation");
        mimes.put("setreg", "application/set-registration-initiation");
        mimes.put("sh", "application/x-sh");
        mimes.put("shar", "application/x-shar");
        mimes.put("sit", "application/x-stuffit");
        mimes.put("snd", "audio/basic");
        mimes.put("spc", "application/x-pkcs7-certificates");
        mimes.put("spl", "application/futuresplash");
        mimes.put("src", "application/x-wais-source");
        mimes.put("sst", "application/vnd.ms-pkicertstore");
        mimes.put("stl", "application/vnd.ms-pkistl");
        mimes.put("stm", "text/html");
        mimes.put("sv4cpio", "application/x-sv4cpio");
        mimes.put("sv4crc", "application/x-sv4crc");
        mimes.put("svg", "image/svg+xml");
        mimes.put("swf", "application/x-shockwave-flash");
        mimes.put("t", APPLICATION_X_TROFF);
        mimes.put("tar", "application/x-tar");
        mimes.put("tcl", "application/x-tcl");
        mimes.put("tex", "application/x-tex");
        mimes.put("texi", "application/x-texinfo");
        mimes.put("texinfo", "application/x-texinfo");
        mimes.put("tgz", "application/x-compressed");
        mimes.put("tif", "image/tiff");
        mimes.put("tiff", "image/tiff");
        mimes.put("tr", APPLICATION_X_TROFF);
        mimes.put("trm", "application/x-msterminal");
        mimes.put("tsv", "text/tab-separated-values");
        mimes.put("txt", "text/plain");
        mimes.put("uls", "text/iuls");
        mimes.put("ustar", "application/x-ustar");
        mimes.put("vcf", "text/x-vcard");
        mimes.put("vrml", X_WORLD_X_VRML);
        mimes.put("wav", "audio/x-wav");
        mimes.put("wcm", APPLICATION_VND_MS_WORKS);
        mimes.put("wdb", APPLICATION_VND_MS_WORKS);
        mimes.put("wks", APPLICATION_VND_MS_WORKS);
        mimes.put("wmf", "application/x-msmetafile");
        mimes.put("wps", APPLICATION_VND_MS_WORKS);
        mimes.put("wri", "application/x-mswrite");
        mimes.put("wrl", X_WORLD_X_VRML);
        mimes.put("wrz", X_WORLD_X_VRML);
        mimes.put("xaf", X_WORLD_X_VRML);
        mimes.put("xbm", "image/x-xbitmap");
        mimes.put("xla", APPLICATION_VND_MS_EXCEL);
        mimes.put("xlc", APPLICATION_VND_MS_EXCEL);
        mimes.put("xlm", APPLICATION_VND_MS_EXCEL);
        mimes.put("xls", APPLICATION_VND_MS_EXCEL);
        mimes.put("xlt", APPLICATION_VND_MS_EXCEL);
        mimes.put("xlw", APPLICATION_VND_MS_EXCEL);
        mimes.put("xof", X_WORLD_X_VRML);
        mimes.put("xpm", "image/x-xpixmap");
        mimes.put("xwd", "image/x-xwindowdump");
        mimes.put("z", "application/x-compress");
        mimes.put("zip", "application/zip");
        mimes.put("jar", "application/zip");
        mimes.put("json", "application/json");
        mimes.put("eml", MESSAGE_RFC822);
        mimes.put("png", "image/png");
        mimes.put("csv", "text/csv");
        mimes.put("afp", "application/vnd.ibm.afplinedata");
        mimes.put("md", "text/x-web-markdown");
        mimes.put("gdoc", "application/vnd.google-apps.document");
        mimes.put("gslide", "application/vnd.google-apps.presentation");
        mimes.put("gsheet", "application/vnd.google-apps.spreadsheet");
        mimes.put("xml", "application/xml");
    }
}

