/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.utils;

import com.google.protobuf.Timestamp;
import com.objective.threesixty.remoteagent.sdk.utils.MimeMap;
import java.time.Instant;
import java.util.Locale;
import lombok.Generated;

public final class RepositoryUtils {
    public static String getMimeTypeForFileName(String fileName) {
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex == -1) {
            return "application/octet-stream";
        }
        String extension = fileName.substring(dotIndex + 1).toLowerCase(Locale.ROOT);
        return RepositoryUtils.getMimeTypeForExtension(extension);
    }

    public static String getMimeTypeForExtension(String extension) {
        return MimeMap.getMimeTypeForExtension(extension);
    }

    public static Timestamp fromInstant(Instant instant) {
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    @Generated
    private RepositoryUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

