/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.action;

import com.azure.core.util.FluxUtil;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.remoteagent.sdk.BinaryDetails;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.AuthConnection;
import com.objective.threesixty.remoteagent.sdk.agent.RepositoryReader;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.dto.CancelFileUploadRequest;
import com.objective.threesixty.remoteagent.sdk.dto.ChunkedFileUploadRequest;
import com.objective.threesixty.remoteagent.sdk.dto.CompleteFileUploadRequest;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import com.objective.threesixty.remoteagent.sdk.utils.CustomParameters;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.client.PrematureCloseException;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

@Component
public final class BinariesAction
implements Action {
    private final Logger log = LogManager.getLogger(this.getClass());
    private static final int MAX_CHUNK_SIZE_MB = 100;
    private static final int MAX_CHUNK_SIZE_BYTES = 0x6400000;
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;
    private final RepositoryReader reader;

    @Override
    public void execute(ObjectiveAction action) {
        BinaryDetails bd;
        CustomParameters parameters = new CustomParameters(action.getValueByIdMap());
        String docId = parameters.getDocId();
        try {
            bd = this.reader.getDocumentBinary(docId, parameters, new AuthConnection(action.getAuthConn()));
            if (bd == null) {
                bd = new BinaryDetails(docId, InputStream.nullInputStream(), "", false, "Null BinaryData returned from getDocumentBinary");
            } else {
                bd.setSuccess(true);
            }
        }
        catch (Exception e) {
            this.log.error("Error getting binaries for source document: {}", (Object)docId, (Object)e);
            bd = new BinaryDetails(docId, InputStream.nullInputStream(), "", false, e.getMessage());
        }
        this.uploadFileInChunks(bd, parameters, action.getRequestId());
    }

    private void uploadFileInChunks(BinaryDetails bd, CustomParameters parameters, String requestId) {
        AtomicInteger chunksRead = new AtomicInteger();
        boolean includeHash = parameters.getIncludeHash();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Beginning chunked binaries upload. {}", (Object)this.formattedLoggingIds(requestId, bd.getDocumentId()));
        }
        try (InputStream is = bd.getInputStream();){
            MessageDigest md = MessageDigest.getInstance("MD5");
            FluxUtil.toFluxByteBuffer((InputStream)(includeHash ? new DigestInputStream(is, md) : is), (int)0x6400000).concatMap(byteBuffer -> {
                byte[] byteArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byteArray);
                return Mono.fromCallable(() -> new AbstractMap.SimpleEntry<Integer, byte[]>(chunksRead.incrementAndGet(), byteArray));
            }).flatMap(entry -> this.uploadChunk(requestId, bd.getDocumentId(), (AbstractMap.SimpleEntry<Integer, byte[]>)entry)).then(Mono.defer(() -> {
                byte[] bytesToHash = includeHash ? md.digest() : null;
                return this.completeUpload(requestId, chunksRead.get(), bd, bytesToHash);
            })).publishOn(Schedulers.boundedElastic()).doOnError(throwable -> this.cancelUpload(requestId, bd.getDocumentId(), (Throwable)throwable).block()).doFinally(signalType -> {
                try {
                    bd.getInputStream().close();
                }
                catch (IOException e) {
                    this.log.error("Error closing input stream for {}", (Object)this.formattedLoggingIds(requestId, bd.getDocumentId()), (Object)e);
                }
            }).onErrorComplete().block();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public ObjectiveActionType getActionType() {
        return ObjectiveActionType.OBJECTIVE_ACTION_BINARIES;
    }

    private Mono<ResponseEntity<String>> uploadChunk(String requestId, String documentId, AbstractMap.SimpleEntry<Integer, byte[]> chunkEntry) {
        int chunkId = chunkEntry.getKey();
        if (this.log.isTraceEnabled()) {
            double sizeInMB = (double)chunkEntry.getValue().length / 1048576.0;
            this.log.trace("Uploading {} Chunk#{}: {}MB", (Object)this.formattedLoggingIds(requestId, documentId), (Object)chunkEntry.getKey(), (Object)sizeInMB);
        }
        String encodedChunk = Base64.getEncoder().encodeToString(chunkEntry.getValue());
        ChunkedFileUploadRequest requestBody = new ChunkedFileUploadRequest(requestId, documentId, chunkId, encodedChunk);
        return this.postRequest(this.commsManager.getChunkedUploadEndpoint(), requestBody);
    }

    private Mono<ResponseEntity<String>> completeUpload(String requestId, int chunksRead, BinaryDetails bd, byte[] bytesToHash) {
        CompleteFileUploadRequest requestBody = new CompleteFileUploadRequest(requestId, chunksRead, bd, null != bytesToHash ? DigestUtils.md5Hex((byte[])bytesToHash) : "");
        if (this.log.isTraceEnabled()) {
            this.log.trace("Completing binary upload for {}", (Object)this.formattedLoggingIds(requestId, requestBody.getDocumentId()));
        }
        return this.postRequest(this.commsManager.getCompleteFileUploadEndpoint(), requestBody);
    }

    private Mono<ResponseEntity<String>> cancelUpload(String requestId, String documentId, Throwable throwable) {
        String errorMsg = this.parseError(throwable);
        CancelFileUploadRequest requestBody = new CancelFileUploadRequest(requestId, documentId, errorMsg);
        if (this.log.isErrorEnabled()) {
            this.log.error("Cancelling binary upload for {}:\n{}", (Object)this.formattedLoggingIds(requestId, documentId), (Object)errorMsg, (Object)throwable);
        }
        return this.postRequest(this.commsManager.getCancelFileUploadEndpoint(), requestBody);
    }

    private Mono<ResponseEntity<String>> postRequest(String endpoint, Object requestBody) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.commsManager.getWebClient().post().uri(endpoint, new Object[0])).header("Authorization", new String[]{this.agentProperties.getToken()})).header("X-Agent-Name", new String[]{this.agentProperties.getAgentName()})).bodyValue(requestBody).retrieve().onStatus(status -> !status.is2xxSuccessful(), ClientResponse::createError).toEntity(String.class).retryWhen((Retry)this.retryBackoffSpec()).doOnSuccess(response -> this.log.debug((String)response.getBody())).onErrorStop();
    }

    private RetryBackoffSpec retryBackoffSpec() {
        return Retry.backoff((long)3L, (Duration)Duration.ofSeconds(2L)).filter(this::isTooManyRequestsException).doBeforeRetry(retrySignal -> this.log.error("Retry attempt #{}:\n{}", (Object)retrySignal.totalRetriesInARow(), (Object)retrySignal.failure().getMessage())).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> retrySignal.failure());
    }

    private boolean isTooManyRequestsException(Throwable throwable) {
        return throwable instanceof WebClientResponseException.TooManyRequests;
    }

    private String formattedLoggingIds(String requestId, String documentId) {
        return "[Request ID: " + requestId + ", DocumentId: " + documentId + "]";
    }

    private String parseError(Throwable error) {
        if (error instanceof WebClientResponseException) {
            WebClientResponseException httpError = (WebClientResponseException)error;
            return String.format("HTTP %s: Body: %s.%n%s", httpError.getStatusCode(), httpError.getResponseBodyAsString(), httpError.getMessage());
        }
        if (error instanceof PrematureCloseException) {
            return String.format("Connection prematurely closed during response. %s", error.getMessage());
        }
        if (error instanceof TimeoutException) {
            return String.format("Timeout occurred while writing document: %s", error.getMessage());
        }
        return error.getMessage();
    }

    @Generated
    public BinariesAction(CommunicationsManager commsManager, RemoteAgentProperties agentProperties, RepositoryReader reader) {
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
        this.reader = reader;
    }
}

