/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.action;

import com.objective.threesixty.AuthConnCheckResult;
import com.objective.threesixty.AuthConnGrpc;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.AuthConnection;
import com.objective.threesixty.remoteagent.sdk.agent.AuthConnectionFactory;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import io.grpc.Channel;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public final class CheckConnectionAction
implements Action {
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;
    private final AuthConnectionFactory factory;

    @Override
    public void execute(ObjectiveAction action) {
        String result = this.factory.checkConnection(new AuthConnection(action.getAuthConn()));
        AuthConnCheckResult resultProto = AuthConnCheckResult.newBuilder().setRequestId(action.getRequestId()).setErrors(result).build();
        AuthConnGrpc.AuthConnBlockingStub stub = (AuthConnGrpc.AuthConnBlockingStub)AuthConnGrpc.newBlockingStub((Channel)this.commsManager.getChannel()).withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getSendAuthConnCheckResultRpc(), TimeUnit.SECONDS);
        stub.sendAuthConnCheckResult(resultProto);
    }

    @Override
    public ObjectiveActionType getActionType() {
        return ObjectiveActionType.OBJECTIVE_ACTION_CHECK_CONNECTION;
    }

    @Generated
    public CheckConnectionAction(CommunicationsManager commsManager, RemoteAgentProperties agentProperties, AuthConnectionFactory factory) {
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
        this.factory = factory;
    }
}

