/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.action;

import com.objective.threesixty.ActionStatusResponse;
import com.objective.threesixty.Document;
import com.objective.threesixty.ExtendedDocument;
import com.objective.threesixty.JobRunGrpc;
import com.objective.threesixty.ObjectiveAction;
import com.objective.threesixty.ObjectiveActionType;
import com.objective.threesixty.Status;
import com.objective.threesixty.StatusCode;
import com.objective.threesixty.remoteagent.sdk.action.Action;
import com.objective.threesixty.remoteagent.sdk.agent.AuthConnection;
import com.objective.threesixty.remoteagent.sdk.agent.RepositoryWriter;
import com.objective.threesixty.remoteagent.sdk.config.RemoteAgentProperties;
import com.objective.threesixty.remoteagent.sdk.utils.CommunicationsManager;
import com.objective.threesixty.remoteagent.sdk.utils.CustomParameters;
import io.grpc.Channel;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.PrematureCloseException;

@Component
public final class WriteDocumentAction
implements Action {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final CommunicationsManager commsManager;
    private final RemoteAgentProperties agentProperties;
    private final RepositoryWriter writer;
    private JobRunGrpc.JobRunBlockingStub stub;

    @Override
    public void execute(ObjectiveAction action) {
        String requestId = action.getRequestId();
        AuthConnection authConn = new AuthConnection(action.getAuthConn());
        CustomParameters parameters = new CustomParameters(action.getValueByIdMap());
        String docId = parameters.getDocId();
        if (this.stub == null) {
            this.stub = JobRunGrpc.newBlockingStub((Channel)this.commsManager.getChannel());
        }
        ExtendedDocument extendedDocument = this.fetchExtendedDocument(requestId);
        AtomicReference<Document> newDoc = new AtomicReference<Document>();
        if (extendedDocument.getDoc().getSize() > 0L && parameters.getIncludeBinaries()) {
            this.handleDocumentWithBinaries(requestId, docId, parameters, extendedDocument, newDoc, authConn);
        } else {
            this.handleDocumentWithoutBinaries(requestId, parameters, extendedDocument, newDoc, authConn);
        }
        this.sendWrittenDocument(requestId, docId, newDoc.get());
    }

    private ExtendedDocument fetchExtendedDocument(String requestId) {
        return ((JobRunGrpc.JobRunBlockingStub)this.stub.withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getGetExtendedDocumentRpc(), TimeUnit.SECONDS)).getExtendedDocument(ExtendedDocument.newBuilder().setRequestId(requestId).build());
    }

    private void handleDocumentWithBinaries(String requestId, String docId, CustomParameters parameters, ExtendedDocument extendedDocument, AtomicReference<Document> newDoc, AuthConnection authConn) {
        this.downloadFile(requestId, docId).flatMap(entity -> this.processDownloadResponse((ResponseEntity<Flux<DataBuffer>>)entity, extendedDocument, parameters, requestId, newDoc, authConn)).timeout(Duration.ofSeconds(parameters.getWriteDocumentTimeout())).doOnError(error -> this.handleError(requestId, docId, newDoc, (Throwable)error)).doOnSuccess(doc -> this.handleSuccessDocument(requestId, newDoc, (Document)doc)).onErrorComplete().block();
    }

    private Mono<Document> processDownloadResponse(ResponseEntity<Flux<DataBuffer>> entity, ExtendedDocument extendedDocument, CustomParameters parameters, String requestId, AtomicReference<Document> newDoc, AuthConnection authConn) {
        this.log.debug("HTTP Headers: {}", (Object)entity.getHeaders());
        return this.writer.writeDocument(extendedDocument.getDoc(), extendedDocument.getMetadata().getDocMetadataMap(), (Flux<DataBuffer>)((Flux)entity.getBody()), parameters, authConn).doOnSuccess(doc -> newDoc.set(doc.toBuilder().setRequestId(requestId).build()));
    }

    private void handleDocumentWithoutBinaries(String requestId, CustomParameters parameters, ExtendedDocument extendedDocument, AtomicReference<Document> newDoc, AuthConnection authConn) {
        this.writer.writeDocument(extendedDocument.getDoc(), extendedDocument.getMetadata().getDocMetadataMap(), (Flux<DataBuffer>)Flux.empty(), parameters, authConn).timeout(Duration.ofSeconds(parameters.getWriteDocumentTimeout())).doOnSuccess(doc -> newDoc.set(doc.toBuilder().setRequestId(requestId).build())).doOnError(error -> this.handleError(requestId, parameters.getDocId(), newDoc, (Throwable)error)).onErrorComplete().block();
    }

    private void sendWrittenDocument(String requestId, String docId, Document document) {
        ActionStatusResponse response = ((JobRunGrpc.JobRunBlockingStub)this.stub.withDeadlineAfter(this.agentProperties.getGrpcServer().getTimeouts().getWriteDocumentRequestRpc(), TimeUnit.SECONDS)).sendWrittenDocument(document);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Request {} to write document {}: {}", (Object)requestId, (Object)docId, (Object)response.getStatus());
        }
    }

    private void handleError(String requestId, String docId, AtomicReference<Document> newDoc, Throwable error) {
        String errorMsg = this.parseError(error);
        this.log.error("Error occurred for document {}: {}", (Object)docId, (Object)errorMsg, (Object)error);
        newDoc.set(this.createFailureDocument(requestId, errorMsg));
    }

    private void handleSuccessDocument(String requestId, AtomicReference<Document> newDoc, Document doc) {
        if (doc == null) {
            newDoc.set(this.createFailureDocument(requestId, "Document write operation timed out"));
        } else {
            newDoc.set(doc.toBuilder().setRequestId(requestId).build());
        }
    }

    private Document createFailureDocument(String requestId, String message) {
        return Document.newBuilder().setRequestId(requestId).setStatus(Status.newBuilder().setCode(StatusCode.STATUS_CODE_FAILURE).setMessage(message).build()).build();
    }

    private Mono<ResponseEntity<Flux<DataBuffer>>> downloadFile(String requestId, String docId) {
        return this.commsManager.getWebClient().get().uri(this.buildDownloadUrl(requestId), new Object[0]).header("Authorization", new String[]{this.agentProperties.getToken()}).header("X-Agent-Name", new String[]{this.agentProperties.getAgentName()}).retrieve().onStatus(status -> !status.is2xxSuccessful(), response -> {
            this.log.error("Failed to download document {}: HTTP {}", (Object)docId, (Object)response.statusCode());
            return response.createException();
        }).toEntityFlux(DataBuffer.class);
    }

    private String parseError(Throwable error) {
        if (error instanceof WebClientResponseException) {
            WebClientResponseException httpError = (WebClientResponseException)error;
            return String.format("HTTP %s: Body: %s.%n%s", httpError.getStatusCode(), httpError.getResponseBodyAsString(), httpError.getMessage());
        }
        if (error instanceof PrematureCloseException) {
            return String.format("Connection prematurely closed during response. %s", error.getMessage());
        }
        if (error instanceof TimeoutException) {
            return String.format("Timeout occurred while writing document: %s", error.getMessage());
        }
        return error.getMessage();
    }

    private String buildDownloadUrl(String requestId) {
        return UriComponentsBuilder.newInstance().path(this.commsManager.getDownloadFileBinariesEndpoint()).buildAndExpand(new Object[]{requestId}).toUriString();
    }

    @Override
    public ObjectiveActionType getActionType() {
        return ObjectiveActionType.OBJECTIVE_ACTION_WRITE_DOCUMENT;
    }

    @Generated
    public WriteDocumentAction(CommunicationsManager commsManager, RemoteAgentProperties agentProperties, RepositoryWriter writer) {
        this.commsManager = commsManager;
        this.agentProperties = agentProperties;
        this.writer = writer;
    }
}

